/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.snowflake;

import me.ahoo.cosid.snowflake.ClockBackwardsSynchronizer;
import me.ahoo.cosid.snowflake.SnowflakeId;
import me.ahoo.cosid.snowflake.exception.ClockBackwardsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClockSyncSnowflakeId
implements SnowflakeId {
    private static final Logger log = LoggerFactory.getLogger(ClockSyncSnowflakeId.class);
    private final SnowflakeId delegate;
    private final ClockBackwardsSynchronizer clockBackwardsSynchronizer;

    public ClockSyncSnowflakeId(SnowflakeId delegate) {
        this(delegate, ClockBackwardsSynchronizer.DEFAULT);
    }

    public ClockSyncSnowflakeId(SnowflakeId delegate, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        this.delegate = delegate;
        this.clockBackwardsSynchronizer = clockBackwardsSynchronizer;
    }

    @Override
    public long generate() {
        try {
            return this.delegate.generate();
        }
        catch (ClockBackwardsException exception) {
            if (log.isWarnEnabled()) {
                log.warn(exception.getMessage(), (Throwable)exception);
            }
            this.clockBackwardsSynchronizer.syncUninterruptibly(this.delegate.getLastTimestamp());
            return this.delegate.generate();
        }
    }

    public SnowflakeId getDelegate() {
        return this.delegate;
    }

    @Override
    public long getEpoch() {
        return this.delegate.getEpoch();
    }

    @Override
    public int getTimestampBit() {
        return this.delegate.getTimestampBit();
    }

    @Override
    public int getMachineBit() {
        return this.delegate.getMachineBit();
    }

    @Override
    public int getSequenceBit() {
        return this.delegate.getSequenceBit();
    }

    @Override
    public boolean isSafeJavascript() {
        return this.delegate.isSafeJavascript();
    }

    @Override
    public long getMaxTimestamp() {
        return this.delegate.getMaxTimestamp();
    }

    @Override
    public long getMaxMachine() {
        return this.delegate.getMaxMachine();
    }

    @Override
    public long getMaxSequence() {
        return this.delegate.getMaxSequence();
    }

    @Override
    public long getLastTimestamp() {
        return this.delegate.getLastTimestamp();
    }

    @Override
    public long getMachineId() {
        return this.delegate.getMachineId();
    }
}

