/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.snowflake.machine;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import me.ahoo.cosid.snowflake.ClockBackwardsSynchronizer;
import me.ahoo.cosid.snowflake.machine.InstanceId;
import me.ahoo.cosid.snowflake.machine.MachineIdDistributor;
import me.ahoo.cosid.snowflake.machine.MachineIdOverflowException;
import me.ahoo.cosid.snowflake.machine.MachineState;
import me.ahoo.cosid.snowflake.machine.MachineStateStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMachineIdDistributor
implements MachineIdDistributor {
    private static final Logger log = LoggerFactory.getLogger(AbstractMachineIdDistributor.class);
    public static final int NOT_FOUND_LAST_STAMP = -1;
    private final MachineStateStorage machineStateStorage;
    private final ClockBackwardsSynchronizer clockBackwardsSynchronizer;

    public AbstractMachineIdDistributor(MachineStateStorage machineStateStorage, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        this.machineStateStorage = machineStateStorage;
        this.clockBackwardsSynchronizer = clockBackwardsSynchronizer;
    }

    @Override
    public int distribute(String namespace, int machineBit, InstanceId instanceId) throws MachineIdOverflowException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkArgument((machineBit > 0 ? 1 : 0) != 0, (String)"machineBit:[%s] must be greater than 0!", (int)machineBit);
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId can not be null!");
        MachineState localState = this.machineStateStorage.get(namespace, instanceId);
        if (!MachineState.NOT_FOUND.equals(localState)) {
            this.clockBackwardsSynchronizer.syncUninterruptibly(localState.getLastTimeStamp());
            return localState.getMachineId();
        }
        localState = this.distribute0(namespace, machineBit, instanceId);
        if (ClockBackwardsSynchronizer.getBackwardsTimeStamp(localState.getLastTimeStamp()) > 0L) {
            this.clockBackwardsSynchronizer.syncUninterruptibly(localState.getLastTimeStamp());
            localState = MachineState.of(localState.getMachineId(), System.currentTimeMillis());
        }
        this.machineStateStorage.set(namespace, localState.getMachineId(), instanceId);
        return localState.getMachineId();
    }

    protected abstract MachineState distribute0(String var1, int var2, InstanceId var3);

    @Override
    public void revert(String namespace, InstanceId instanceId) throws MachineIdOverflowException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId can not be null!");
        MachineState lastLocalState = this.machineStateStorage.get(namespace, instanceId);
        if (ClockBackwardsSynchronizer.getBackwardsTimeStamp(lastLocalState.getLastTimeStamp()) < 0L) {
            lastLocalState = MachineState.of(lastLocalState.getMachineId(), System.currentTimeMillis());
            this.machineStateStorage.set(namespace, lastLocalState.getMachineId(), instanceId);
        }
        this.revert0(namespace, instanceId, lastLocalState);
    }

    protected abstract void revert0(String var1, InstanceId var2, MachineState var3);
}

