/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheObject;
import net.oschina.j2cache.J2Cache;

public class CacheTester {
    public static void main(String[] args) {
        System.setProperty("java.net.preferIPv4Stack", "true");
        CacheChannel cache = J2Cache.getChannel();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        block3: while (true) {
            try {
                while (true) {
                    System.out.print("> ");
                    System.out.flush();
                    String line = in.readLine().trim();
                    if (line.equalsIgnoreCase("quit") || line.equalsIgnoreCase("exit")) break block3;
                    String[] cmds = line.split(" ");
                    if ("get".equalsIgnoreCase(cmds[0])) {
                        CacheObject obj = cache.get(cmds[1], cmds[2]);
                        System.out.printf("[%s,%s,L%d]=>%s\n", obj.getRegion(), obj.getKey(), obj.getLevel(), obj.getValue());
                        continue;
                    }
                    if ("set".equalsIgnoreCase(cmds[0])) {
                        cache.set(cmds[1], cmds[2], cmds[3]);
                        System.out.printf("[%s,%s]<=%s\n", cmds[1], cmds[2], cmds[3]);
                        continue;
                    }
                    if ("evict".equalsIgnoreCase(cmds[0])) {
                        cache.evict(cmds[1], cmds[2]);
                        System.out.printf("[%s,%s]=>null\n", cmds[1], cmds[2]);
                        continue;
                    }
                    if ("clear".equalsIgnoreCase(cmds[0])) {
                        cache.clear(cmds[1]);
                        System.out.printf("Cache [%s] clear.\n", cmds[1]);
                        continue;
                    }
                    if ("help".equalsIgnoreCase(cmds[0])) {
                        CacheTester.printHelp();
                        continue;
                    }
                    System.out.println("Unknown command.");
                    CacheTester.printHelp();
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("Wrong arguments.");
                CacheTester.printHelp();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        cache.close();
        System.exit(0);
    }

    private static void printHelp() {
        System.out.println("Usage: [cmd] region key [value]");
        System.out.println("cmd: get/set/evict/quit/exit/help");
    }
}

