/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.util.Properties;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.ClusterPolicy;
import net.oschina.j2cache.JGroupsClusterPolicy;
import net.oschina.j2cache.NoneClusterPolicy;
import net.oschina.j2cache.redis.RedisPubSubClusterPolicy;

public class ClusterPolicyFactory {
    private ClusterPolicyFactory() {
    }

    public static final ClusterPolicy init(String broadcast, Properties props) {
        ClusterPolicy policy = "redis".equalsIgnoreCase(broadcast) ? ClusterPolicyFactory.redis(props) : ("jgroups".equalsIgnoreCase(broadcast) ? ClusterPolicyFactory.jgroups(props) : ("none".equalsIgnoreCase(broadcast) ? new NoneClusterPolicy() : ClusterPolicyFactory.custom(broadcast, props)));
        return policy;
    }

    private static final ClusterPolicy redis(Properties props) {
        String name = props.getProperty("channel");
        RedisPubSubClusterPolicy policy = new RedisPubSubClusterPolicy(name, props);
        policy.connect(props);
        return policy;
    }

    private static final ClusterPolicy jgroups(Properties props) {
        String name = props.getProperty("channel.name");
        JGroupsClusterPolicy policy = new JGroupsClusterPolicy(name, props);
        policy.connect(props);
        return policy;
    }

    private static final ClusterPolicy custom(String classname, Properties props) {
        try {
            ClusterPolicy policy = (ClusterPolicy)Class.forName(classname).newInstance();
            policy.connect(props);
            return policy;
        }
        catch (Exception e) {
            throw new CacheException("Failed in load custom cluster policy. class = " + classname, e);
        }
    }
}

