/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.oschina.j2cache.Level1Cache;

public class CaffeineCache
implements Level1Cache {
    private Cache<String, Object> cache;
    private long size;
    private long expire;

    public CaffeineCache(Cache<String, Object> cache, long size, long expire) {
        this.cache = cache;
        this.size = size;
        this.expire = expire;
    }

    @Override
    public long ttl() {
        return this.expire;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public Object get(String key) {
        return this.cache.getIfPresent((Object)key);
    }

    @Override
    public Map<String, Object> get(Collection<String> keys) {
        return this.cache.getAllPresent(keys);
    }

    @Override
    public void put(String key, Object value) {
        this.cache.put((Object)key, value);
    }

    @Override
    public void put(Map<String, Object> elements) {
        this.cache.putAll(elements);
    }

    @Override
    public Collection<String> keys() {
        return this.cache.asMap().keySet();
    }

    @Override
    public void evict(String ... keys) {
        this.cache.invalidateAll(Arrays.asList(keys));
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }
}

