/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.ehcache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.Level1Cache;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

public class EhCache
implements Level1Cache,
CacheEventListener {
    private Cache cache;
    private CacheExpiredListener listener;

    public EhCache(Cache cache, CacheExpiredListener listener) {
        this.cache = cache;
        this.cache.getCacheEventNotificationService().registerListener((CacheEventListener)this);
        this.listener = listener;
    }

    @Override
    public long ttl() {
        return this.cache.getCacheConfiguration().getTimeToLiveSeconds();
    }

    @Override
    public long size() {
        return this.cache.getCacheConfiguration().getMaxEntriesLocalHeap();
    }

    @Override
    public Collection<String> keys() {
        return this.cache.getKeys();
    }

    @Override
    public Serializable get(String key) {
        if (key == null) {
            return null;
        }
        Element elem = this.cache.get((Serializable)((Object)key));
        Object obj = elem != null ? elem.getObjectValue() : null;
        return obj == null || obj.getClass().equals(Object.class) ? null : (Serializable)elem.getObjectValue();
    }

    @Override
    public void put(String key, Object value) {
        this.cache.put(new Element((Object)key, value));
    }

    @Override
    public void evict(String ... keys) {
        this.cache.removeAll(Arrays.asList(keys));
    }

    @Override
    public Map<String, Object> get(Collection<String> keys) {
        Map elements = this.cache.getAll(keys);
        HashMap<String, Object> results = new HashMap<String, Object>();
        elements.forEach((k, v) -> {
            if (v != null) {
                results.put((String)k, v.getObjectValue());
            }
        });
        return results;
    }

    @Override
    public boolean exists(String key) {
        return this.cache.isKeyInCache((Object)key);
    }

    @Override
    public void put(Map<String, Object> elements) {
        ArrayList elems = new ArrayList();
        elements.forEach((k, v) -> elems.add(new Element(k, v)));
        this.cache.putAll(elems);
    }

    @Override
    public void clear() {
        this.cache.removeAll();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void notifyElementExpired(Ehcache cache, Element elem) {
        if (this.listener != null) {
            this.listener.notifyElementExpired(cache.getName(), (String)elem.getObjectKey());
        }
    }

    public void notifyElementEvicted(Ehcache cache, Element elem) {
    }

    public void notifyElementPut(Ehcache cache, Element elem) {
    }

    public void notifyElementRemoved(Ehcache cache, Element elem) {
    }

    public void notifyElementUpdated(Ehcache cache, Element elem) {
    }

    public void notifyRemoveAll(Ehcache cache) {
    }

    public void dispose() {
    }
}

