/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.memcached;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.oschina.j2cache.Level2Cache;
import net.rubyeye.xmemcached.MemcachedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemCache
implements Level2Cache {
    private static final Logger log = LoggerFactory.getLogger(MemCache.class);
    private String region;
    private MemcachedClient client;

    public MemCache(String region, MemcachedClient client) {
        this.region = region;
        this.client = client;
    }

    @Override
    public boolean supportTTL() {
        return true;
    }

    @Override
    public byte[] getBytes(String key) {
        try {
            return (byte[])this.client.get(this._key(key));
        }
        catch (Exception e) {
            log.error("Failed to get data from memcached.", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<byte[]> getBytes(Collection<String> keys) {
        try {
            return keys.stream().map(k -> this.getBytes(this._key((String)k))).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("Failed to get data from memcached.", (Throwable)e);
            return null;
        }
    }

    @Override
    public void setBytes(String key, byte[] bytes) {
        this.setBytes(key, bytes, -1L);
    }

    @Override
    public void setBytes(Map<String, byte[]> bytes) {
        this.setBytes(bytes, -1L);
    }

    @Override
    public void setBytes(String key, byte[] bytes, long timeToLiveInSeconds) {
        try {
            this.client.set(this._key(key), (int)timeToLiveInSeconds, (Object)bytes);
        }
        catch (Exception e) {
            log.error("Failed to set data to memcached.", (Throwable)e);
        }
    }

    @Override
    public void setBytes(Map<String, byte[]> bytes, long timeToLiveInSeconds) {
        try {
            for (String key : bytes.keySet()) {
                String mkey = this._key(key);
                this.client.set(mkey, (int)timeToLiveInSeconds, (Object)bytes.get(key));
            }
        }
        catch (Exception e) {
            log.error("Failed to set data to memcached.", (Throwable)e);
        }
    }

    @Override
    public Collection<String> keys() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void evict(String ... keys) {
        if (keys.length > 0) {
            try {
                for (String key : keys) {
                    this.client.delete(this._key(key));
                }
            }
            catch (Exception e) {
                log.error("Failed to set data to memcached.", (Throwable)e);
            }
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private String _key(String key) {
        return this.region + ":" + key;
    }
}

