/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.form;

import com.vaadin.data.Validator;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import java.util.List;
import java.util.Map;
import org.activiti.engine.FormService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.form.FormProperty;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.form.FormPropertiesComponent;

public class FormPropertiesForm
extends VerticalLayout {
    private static final long serialVersionUID = -3197331726904715949L;
    protected transient FormService formService = ProcessEngines.getDefaultProcessEngine().getFormService();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected Label formTitle;
    protected Button submitFormButton;
    protected Button cancelFormButton;
    protected FormPropertiesComponent formPropertiesComponent;

    public FormPropertiesForm() {
        this.addStyleName("block-holder");
        this.addStyleName("formprops");
        this.initTitle();
        this.initFormPropertiesComponent();
        this.initButtons();
        this.initListeners();
    }

    public void setFormProperties(List<FormProperty> formProperties) {
        this.formPropertiesComponent.setFormProperties(formProperties);
    }

    public void setSubmitButtonCaption(String caption) {
        this.submitFormButton.setCaption(caption);
    }

    public void setCancelButtonCaption(String caption) {
        this.cancelFormButton.setCaption(caption);
    }

    public void setFormHelp(String caption) {
        this.formTitle.setValue((Object)caption);
        this.formTitle.setVisible(caption != null);
    }

    public void clear() {
        this.formPropertiesComponent.setFormProperties(this.formPropertiesComponent.getFormProperties());
    }

    protected void initTitle() {
        this.formTitle = new Label();
        this.formTitle.addStyleName("h4");
        this.formTitle.setVisible(false);
        this.addComponent((Component)this.formTitle);
    }

    protected void initButtons() {
        this.submitFormButton = new Button();
        this.cancelFormButton = new Button();
        HorizontalLayout buttons = new HorizontalLayout();
        buttons.setSpacing(true);
        buttons.setWidth(100.0f, 8);
        buttons.addStyleName("block-holder");
        buttons.addComponent((Component)this.submitFormButton);
        buttons.setComponentAlignment((Component)this.submitFormButton, Alignment.BOTTOM_RIGHT);
        buttons.addComponent((Component)this.cancelFormButton);
        buttons.setComponentAlignment((Component)this.cancelFormButton, Alignment.BOTTOM_RIGHT);
        Label buttonSpacer = new Label();
        buttons.addComponent((Component)buttonSpacer);
        buttons.setExpandRatio((Component)buttonSpacer, 1.0f);
        this.addComponent((Component)buttons);
    }

    protected void initFormPropertiesComponent() {
        this.formPropertiesComponent = new FormPropertiesComponent();
        this.addComponent((Component)this.formPropertiesComponent);
    }

    protected void initListeners() {
        this.submitFormButton.addListener(new Button.ClickListener(){
            private static final long serialVersionUID = -6091586145870618870L;

            public void buttonClick(Button.ClickEvent event) {
                try {
                    Map<String, String> formProperties = FormPropertiesForm.this.formPropertiesComponent.getFormPropertyValues();
                    FormPropertiesForm.this.fireEvent(new FormPropertiesEvent((Component)FormPropertiesForm.this, "SUBMIT", formProperties));
                    FormPropertiesForm.this.submitFormButton.setComponentError(null);
                }
                catch (Validator.InvalidValueException invalidValueException) {
                    // empty catch block
                }
            }
        });
        this.cancelFormButton.addListener(new Button.ClickListener(){
            private static final long serialVersionUID = -8980500491522472381L;

            public void buttonClick(Button.ClickEvent event) {
                FormPropertiesForm.this.fireEvent(new FormPropertiesEvent((Component)FormPropertiesForm.this, "CANCEL"));
                FormPropertiesForm.this.submitFormButton.setComponentError(null);
            }
        });
    }

    public void hideCancelButton() {
        this.cancelFormButton.setVisible(false);
    }

    protected void addEmptySpace(ComponentContainer container) {
        Label emptySpace = new Label("&nbsp;", 3);
        emptySpace.setSizeUndefined();
        container.addComponent((Component)emptySpace);
    }

    public class FormPropertiesEvent
    extends Component.Event {
        private static final long serialVersionUID = -410814526942034125L;
        public static final String TYPE_SUBMIT = "SUBMIT";
        public static final String TYPE_CANCEL = "CANCEL";
        private String type;
        private Map<String, String> formProperties;

        public FormPropertiesEvent(Component source, String type) {
            super(source);
            this.type = type;
        }

        public FormPropertiesEvent(Component source, String type, Map<String, String> formProperties) {
            this(source, type);
            this.formProperties = formProperties;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, String> getFormProperties() {
            return this.formProperties;
        }
    }
}

