/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.deployment;

import com.vaadin.ui.Upload;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipInputStream;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.NotificationManager;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.ui.management.deployment.DeploymentFilter;
import org.activiti.explorer.ui.management.deployment.DeploymentFilterFactory;

public class DeploymentUploadReceiver
implements Upload.Receiver,
Upload.FinishedListener {
    private static final long serialVersionUID = 1L;
    protected transient RepositoryService repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected NotificationManager notificationManager = ExplorerApp.get().getNotificationManager();
    protected ViewManager viewManager = ExplorerApp.get().getViewManager();
    protected ByteArrayOutputStream outputStream;
    protected String fileName;
    protected boolean validFile = false;
    protected Deployment deployment;

    public OutputStream receiveUpload(String filename, String mimeType) {
        this.fileName = filename;
        this.outputStream = new ByteArrayOutputStream();
        return this.outputStream;
    }

    public void uploadFinished(Upload.FinishedEvent event) {
        this.deployUploadedFile();
        if (this.validFile) {
            this.showUploadedDeployment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployUploadedFile() {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().name(this.fileName);
        DeploymentFilter deploymentFilter = (DeploymentFilter)ExplorerApp.get().getComponentFactory(DeploymentFilterFactory.class).create();
        try {
            try {
                if (this.fileName.endsWith(".bpmn20.xml") || this.fileName.endsWith(".bpmn")) {
                    this.validFile = true;
                    deploymentBuilder.addInputStream(this.fileName, (InputStream)new ByteArrayInputStream(this.outputStream.toByteArray()));
                } else if (this.fileName.endsWith(".bar") || this.fileName.endsWith(".zip")) {
                    this.validFile = true;
                    deploymentBuilder.addZipInputStream(new ZipInputStream(new ByteArrayInputStream(this.outputStream.toByteArray())));
                } else {
                    this.notificationManager.showErrorNotification("deployment.upload.invalid.file", this.i18nManager.getMessage("deployment.upload.invalid.file.explanation"));
                }
                if (this.validFile) {
                    deploymentFilter.beforeDeploy(deploymentBuilder);
                    this.deployment = deploymentBuilder.deploy();
                }
            }
            catch (ActivitiException e) {
                String errorMsg = e.getMessage().replace(System.getProperty("line.separator"), "<br/>");
                this.notificationManager.showErrorNotification("deployment.upload.failed", errorMsg);
                throw e;
            }
        }
        finally {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    this.notificationManager.showErrorNotification("Server-side error", e.getMessage());
                }
            }
        }
    }

    protected void showUploadedDeployment() {
        this.viewManager.showDeploymentPage(this.deployment.getId());
    }
}

