/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.identity;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.ObjectProperty;
import com.vaadin.data.util.PropertysetItem;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;

public class GroupListQuery
extends AbstractLazyLoadingQuery {
    protected transient IdentityService identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();

    @Override
    public int size() {
        return (int)this.identityService.createGroupQuery().count();
    }

    @Override
    public List<Item> loadItems(int start, int count) {
        List groups = ((GroupQuery)((GroupQuery)this.identityService.createGroupQuery().orderByGroupId().asc()).orderByGroupName().asc()).listPage(start, count);
        ArrayList<Item> groupListItems = new ArrayList<Item>();
        for (Group group : groups) {
            groupListItems.add((Item)new GroupListItem(group));
        }
        return groupListItems;
    }

    @Override
    public Item loadSingleResult(String id) {
        return new GroupListItem((Group)this.identityService.createGroupQuery().groupId(id).singleResult());
    }

    @Override
    public void setSorting(Object[] propertyIds, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }

    class GroupListItem
    extends PropertysetItem
    implements Comparable<GroupListItem> {
        private static final long serialVersionUID = 1L;

        public GroupListItem(Group group) {
            this.addItemProperty("id", (Property)new ObjectProperty((Object)group.getId(), String.class));
            if (group.getName() != null) {
                this.addItemProperty("name", (Property)new ObjectProperty((Object)(group.getName() + " (" + group.getName() + ")"), String.class));
            } else {
                this.addItemProperty("name", (Property)new ObjectProperty((Object)("(" + group.getId() + ")"), String.class));
            }
        }

        @Override
        public int compareTo(GroupListItem other) {
            String id = (String)this.getItemProperty("id").getValue();
            String otherId = (String)other.getItemProperty("id").getValue();
            return id.compareTo(otherId);
        }
    }
}

