/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.infra.env;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.env.HostException;

public final class IpUtils {
    public static final String IP_REGEX = "((\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)){3})";
    public static final String PREFERRED_NETWORK_INTERFACE = "elasticjob.preferred.network.interface";
    public static final String PREFERRED_NETWORK_IP = "elasticjob.preferred.network.ip";
    private static volatile String cachedIpAddress;
    private static volatile String cachedHostName;

    public static String getIp() {
        if (null != cachedIpAddress) {
            return cachedIpAddress;
        }
        NetworkInterface networkInterface = IpUtils.findNetworkInterface();
        if (null != networkInterface) {
            Enumeration<InetAddress> ipAddresses = networkInterface.getInetAddresses();
            while (ipAddresses.hasMoreElements()) {
                InetAddress ipAddress = ipAddresses.nextElement();
                if (!IpUtils.isValidAddress(ipAddress) || !IpUtils.isPreferredAddress(ipAddress)) continue;
                cachedIpAddress = ipAddress.getHostAddress();
                return cachedIpAddress;
            }
        }
        throw new HostException("ip is null");
    }

    private static NetworkInterface findNetworkInterface() {
        Enumeration<NetworkInterface> interfaces;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            throw new HostException(ex);
        }
        LinkedList<NetworkInterface> validNetworkInterfaces = new LinkedList<NetworkInterface>();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            if (IpUtils.ignoreNetworkInterface(networkInterface)) continue;
            validNetworkInterfaces.add(networkInterface);
        }
        NetworkInterface result = null;
        for (NetworkInterface each : validNetworkInterfaces) {
            if (!IpUtils.isPreferredNetworkInterface(each)) continue;
            result = each;
            break;
        }
        if (null == result) {
            result = IpUtils.getFirstNetworkInterface(validNetworkInterfaces);
        }
        return result;
    }

    private static NetworkInterface getFirstNetworkInterface(List<NetworkInterface> validNetworkInterfaces) {
        NetworkInterface result = null;
        block0: for (NetworkInterface each : validNetworkInterfaces) {
            Enumeration<InetAddress> addresses = each.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress inetAddress = addresses.nextElement();
                if (!IpUtils.isValidAddress(inetAddress) || !IpUtils.isPreferredAddress(inetAddress)) continue;
                result = each;
                continue block0;
            }
        }
        if (null == result && !validNetworkInterfaces.isEmpty()) {
            result = validNetworkInterfaces.get(0);
        }
        return result;
    }

    private static boolean isPreferredNetworkInterface(NetworkInterface networkInterface) {
        String preferredNetworkInterface = System.getProperty(PREFERRED_NETWORK_INTERFACE);
        return Objects.equals(networkInterface.getDisplayName(), preferredNetworkInterface);
    }

    private static boolean ignoreNetworkInterface(NetworkInterface networkInterface) {
        try {
            return null == networkInterface || networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp();
        }
        catch (SocketException ex) {
            return true;
        }
    }

    private static boolean isPreferredAddress(InetAddress inetAddress) {
        String preferredNetworkIp = System.getProperty(PREFERRED_NETWORK_IP);
        if (null == preferredNetworkIp) {
            return true;
        }
        String hostAddress = inetAddress.getHostAddress();
        return hostAddress.startsWith(preferredNetworkIp) || hostAddress.matches(preferredNetworkIp);
    }

    private static boolean isValidAddress(InetAddress inetAddress) {
        try {
            return !inetAddress.isLoopbackAddress() && !inetAddress.isAnyLocalAddress() && !IpUtils.isIp6Address(inetAddress) && inetAddress.isReachable(100);
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static boolean isIp6Address(InetAddress ipAddress) {
        return ipAddress instanceof Inet6Address;
    }

    public static String getHostName() {
        if (null != cachedHostName) {
            return cachedHostName;
        }
        try {
            cachedHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            cachedHostName = "unknown";
        }
        return cachedHostName;
    }

    @Generated
    private IpUtils() {
    }
}

