/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.lifecycle.internal.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodePath;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.ShardingStatisticsAPI;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.domain.ShardingInfo;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class ShardingStatisticsAPIImpl
implements ShardingStatisticsAPI {
    private final CoordinatorRegistryCenter regCenter;

    @Override
    public Collection<ShardingInfo> getShardingInfo(String jobName) {
        String shardingRootPath = new JobNodePath(jobName).getShardingNodePath();
        List items = this.regCenter.getChildrenKeys(shardingRootPath);
        ArrayList<ShardingInfo> result = new ArrayList<ShardingInfo>(items.size());
        for (String each : items) {
            result.add(this.getShardingInfo(jobName, each));
        }
        Collections.sort(result);
        return result;
    }

    private ShardingInfo getShardingInfo(String jobName, String item) {
        ShardingInfo result = new ShardingInfo();
        result.setItem(Integer.parseInt(item));
        JobNodePath jobNodePath = new JobNodePath(jobName);
        String instanceId = this.regCenter.get(jobNodePath.getShardingNodePath(item, "instance"));
        boolean disabled = this.regCenter.isExisted(jobNodePath.getShardingNodePath(item, "disabled"));
        boolean running = this.regCenter.isExisted(jobNodePath.getShardingNodePath(item, "running"));
        boolean shardingError = !this.regCenter.isExisted(jobNodePath.getInstanceNodePath(instanceId));
        result.setStatus(ShardingInfo.ShardingStatus.getShardingStatus(disabled, running, shardingError));
        result.setFailover(this.regCenter.isExisted(jobNodePath.getShardingNodePath(item, "failover")));
        if (null != instanceId) {
            JobInstance jobInstance = (JobInstance)YamlEngine.unmarshal((String)this.regCenter.get(jobNodePath.getInstanceNodePath(instanceId)), JobInstance.class);
            result.setServerIp(jobInstance.getServerIp());
            result.setInstanceId(jobInstance.getJobInstanceId());
        }
        return result;
    }

    @Generated
    public ShardingStatisticsAPIImpl(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
    }
}

