/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.spi.context;

import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;

public final class EncryptColumnDataType {
    private final String typeName;
    private final int dataType;

    public EncryptColumnDataType(String typeName, Map<String, Integer> dataTypes) {
        this.typeName = typeName;
        this.dataType = EncryptColumnDataType.getDataTypeByTypeName(typeName, dataTypes);
    }

    private static Integer getDataTypeByTypeName(String typeName, Map<String, Integer> dataTypes) {
        Integer result = dataTypes.get(EncryptColumnDataType.getExactlyTypeName(typeName));
        if (null == result) {
            throw new ShardingSphereConfigurationException("Can not get data types, please check config: %s", new Object[]{typeName});
        }
        return result;
    }

    private static String getExactlyTypeName(String dataTypeName) {
        String dataType = dataTypeName.trim().toLowerCase();
        if (dataType.contains("(")) {
            return dataType.substring(0, dataType.indexOf("("));
        }
        if (dataType.contains(" ")) {
            return dataType.substring(0, dataType.indexOf(" "));
        }
        return dataType;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public int getDataType() {
        return this.dataType;
    }
}

