/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.creator;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaData;

public final class DataSourceReflection {
    private static final Collection<Class<?>> GENERAL_CLASS_TYPES = Sets.newHashSet((Object[])new Class[]{Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, String.class, Collection.class, List.class, Properties.class});
    private static final Collection<String> SKIPPED_PROPERTY_KEYS = Sets.newHashSet((Object[])new String[]{"loginTimeout"});
    private static final String IS_PREFIX = "is";
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    private final DataSource dataSource;
    private final Method[] dataSourceMethods;

    public DataSourceReflection(DataSource dataSource) {
        this.dataSource = dataSource;
        this.dataSourceMethods = dataSource.getClass().getMethods();
    }

    public Map<String, Object> convertToProperties() {
        Map<String, Object> getterProps = this.convertToProperties(GETTER_PREFIX);
        Map<String, Object> isProps = this.convertToProperties(IS_PREFIX);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(getterProps.size() + isProps.size(), 1.0f);
        result.putAll(getterProps);
        result.putAll(isProps);
        return result;
    }

    private Map<String, Object> convertToProperties(String prefix) {
        Collection<Method> getterMethods = this.findAllGetterMethods(prefix);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(getterMethods.size(), 1.0f);
        for (Method each : getterMethods) {
            Object fieldValue;
            String fieldName = DataSourceReflection.getGetterFieldName(each, prefix);
            if (!GENERAL_CLASS_TYPES.contains(each.getReturnType()) || SKIPPED_PROPERTY_KEYS.contains(fieldName) || null == (fieldValue = each.invoke((Object)this.dataSource, new Object[0]))) continue;
            result.put(fieldName, fieldValue);
        }
        return result;
    }

    private Collection<Method> findAllGetterMethods(String methodPrefix) {
        HashSet<Method> result = new HashSet<Method>(this.dataSourceMethods.length);
        for (Method each : this.dataSourceMethods) {
            if (!each.getName().startsWith(methodPrefix) || 0 != each.getParameterTypes().length) continue;
            result.add(each);
        }
        return result;
    }

    private static String getGetterFieldName(Method method, String methodPrefix) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, method.getName().substring(methodPrefix.length()));
    }

    public void setField(String fieldName, Object fieldValue) {
        if (null != fieldValue && !this.isSkippedProperty(fieldName)) {
            this.findSetterMethod(fieldName).ifPresent(optional -> this.setField((Method)optional, fieldValue));
        }
    }

    private void setField(Method method, Object fieldValue) {
        Class<?> paramType = method.getParameterTypes()[0];
        if (paramType == Integer.TYPE) {
            method.invoke((Object)this.dataSource, Integer.parseInt(fieldValue.toString()));
        } else if (paramType == Long.TYPE) {
            method.invoke((Object)this.dataSource, Long.parseLong(fieldValue.toString()));
        } else if (paramType == Boolean.TYPE || paramType == Boolean.class) {
            method.invoke((Object)this.dataSource, Boolean.parseBoolean(fieldValue.toString()));
        } else if (paramType == String.class) {
            method.invoke((Object)this.dataSource, fieldValue.toString());
        } else if (paramType == Properties.class) {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)((Map)fieldValue));
            method.invoke((Object)this.dataSource, props);
        } else {
            method.invoke((Object)this.dataSource, fieldValue);
        }
    }

    private boolean isSkippedProperty(String key) {
        return SKIPPED_PROPERTY_KEYS.contains(key);
    }

    private Optional<Method> findSetterMethod(String fieldName) {
        String setterMethodName = SETTER_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
        return Arrays.stream(this.dataSourceMethods).filter(each -> each.getName().equals(setterMethodName) && 1 == each.getParameterTypes().length).findFirst();
    }

    public void addDefaultDataSourceProperties(DataSourcePoolMetaData dataSourcePoolMetaData) {
        String jdbcUrl = dataSourcePoolMetaData.getJdbcUrlMetaData().getJdbcUrl(this.dataSource);
        Properties jdbcUrlProps = dataSourcePoolMetaData.getJdbcUrlMetaData().getJdbcUrlProperties(this.dataSource);
        if (null == jdbcUrl || null == jdbcUrlProps) {
            return;
        }
        DataSourceMetaData dataSourceMetaData = DatabaseTypeRegistry.getDatabaseTypeByURL(jdbcUrl).getDataSourceMetaData(jdbcUrl, null);
        Properties queryProps = dataSourceMetaData.getQueryProperties();
        for (Map.Entry<Object, Object> entry : dataSourceMetaData.getDefaultQueryProperties().entrySet()) {
            String defaultPropertyKey = entry.getKey().toString();
            String defaultPropertyValue = entry.getValue().toString();
            if (this.containsDefaultProperty(defaultPropertyKey, jdbcUrlProps, queryProps)) continue;
            dataSourcePoolMetaData.getJdbcUrlMetaData().appendJdbcUrlProperties(defaultPropertyKey, defaultPropertyValue, this.dataSource);
        }
    }

    private boolean containsDefaultProperty(String defaultPropertyKey, Properties targetDataSourceProps, Properties queryProps) {
        return targetDataSourceProps.containsKey(defaultPropertyKey) || queryProps.containsKey(defaultPropertyKey);
    }
}

