/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.merge.result.impl.local;

import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shardingsphere.infra.util.json.JsonUtils;

public final class LocalDataQueryResultRow {
    private final List<Object> data;

    public LocalDataQueryResultRow(Object ... data) {
        this.data = Stream.of(data).map(this::convert).collect(Collectors.toList());
    }

    private Object convert(Object data) {
        if (null == data || "null".equals(data)) {
            return "";
        }
        if (data instanceof Optional) {
            return ((Optional)data).isPresent() ? this.convert(((Optional)data).get()) : "";
        }
        if (data instanceof String) {
            return data;
        }
        if (data instanceof Boolean || data instanceof Integer || data instanceof Long || data instanceof LocalDateTime) {
            return data.toString();
        }
        if (data instanceof Enum) {
            return ((Enum)data).name();
        }
        if (data instanceof Properties) {
            return ((Properties)data).isEmpty() ? "" : JsonUtils.toJsonString(this.convert((Properties)data));
        }
        if (data instanceof Map) {
            return ((Map)data).isEmpty() ? "" : JsonUtils.toJsonString((Object)data);
        }
        if (data instanceof Collection) {
            return ((Collection)data).isEmpty() ? "" : JsonUtils.toJsonString((Object)data);
        }
        return JsonUtils.toJsonString((Object)data);
    }

    private Map<Object, Object> convert(Properties props) {
        return props.keySet().stream().map(Object::toString).sorted().collect(Collectors.toMap(each -> each, props::get, (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public Object getCell(int columnIndex) {
        Preconditions.checkArgument((columnIndex > 0 && columnIndex < this.data.size() + 1 ? 1 : 0) != 0);
        return this.data.get(columnIndex - 1);
    }
}

