/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.api;

import com.google.common.cache.LoadingCache;
import org.apache.shardingsphere.sql.parser.api.CacheOption;
import org.apache.shardingsphere.sql.parser.core.ParseContext;
import org.apache.shardingsphere.sql.parser.core.database.cache.ParseTreeCacheBuilder;
import org.apache.shardingsphere.sql.parser.core.database.parser.SQLParserExecutor;

public final class SQLParserEngine {
    private final SQLParserExecutor sqlParserExecutor;
    private final LoadingCache<String, ParseContext> parseTreeCache;

    public SQLParserEngine(String databaseType, CacheOption cacheOption, boolean sqlCommentParseEnabled) {
        this.sqlParserExecutor = new SQLParserExecutor(databaseType, sqlCommentParseEnabled);
        this.parseTreeCache = ParseTreeCacheBuilder.build(cacheOption, databaseType, sqlCommentParseEnabled);
    }

    public ParseContext parse(String sql, boolean useCache) {
        return useCache ? (ParseContext)this.parseTreeCache.getUnchecked((Object)sql) : this.sqlParserExecutor.parse(sql);
    }
}

