/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.api;

import java.util.Collection;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.apache.shardingsphere.sql.parser.core.ParseContext;
import org.apache.shardingsphere.sql.parser.core.database.visitor.SQLVisitorFactory;
import org.apache.shardingsphere.sql.parser.core.database.visitor.SQLVisitorRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.AbstractSQLStatement;

public final class SQLVisitorEngine {
    private final String databaseType;
    private final String visitorType;
    private final Properties props;

    public <T> T visit(ParseContext parseContext) {
        ParseTreeVisitor visitor = SQLVisitorFactory.newInstance(this.databaseType, this.visitorType, SQLVisitorRule.valueOf(parseContext.getParseTree().getClass()), this.props);
        Object result = parseContext.getParseTree().accept(visitor);
        this.appendSQLComments(parseContext, result);
        return (T)result;
    }

    private <T> void appendSQLComments(ParseContext parseContext, T visitResult) {
        if (!parseContext.getHiddenTokens().isEmpty() && visitResult instanceof AbstractSQLStatement) {
            Collection commentSegments = parseContext.getHiddenTokens().stream().map(each -> new CommentSegment(each.getText(), each.getStartIndex(), each.getStopIndex())).collect(Collectors.toList());
            ((AbstractSQLStatement)visitResult).getCommentSegments().addAll(commentSegments);
        }
    }

    @Generated
    public SQLVisitorEngine(String databaseType, String visitorType, Properties props) {
        this.databaseType = databaseType;
        this.visitorType = visitorType;
        this.props = props;
    }
}

