/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.aot.dmn;

import java.util.List;
import org.flowable.spring.boot.aot.BaseAutoDeployResourceContribution;
import org.flowable.spring.boot.dmn.FlowableDmnProperties;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.ClassUtils;

public class FlowableDmnAutoDeployBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    protected final ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        if (!ClassUtils.isPresent((String)"org.flowable.dmn.spring.SpringDmnEngineConfiguration", (ClassLoader)beanFactory.getBeanClassLoader())) {
            return null;
        }
        if (!beanFactory.containsBean("dmnEngineConfiguration")) {
            return null;
        }
        FlowableDmnProperties properties = (FlowableDmnProperties)beanFactory.getBeanProvider(FlowableDmnProperties.class).getIfAvailable();
        if (properties == null || !properties.isDeployResources()) {
            return null;
        }
        List<String> locationSuffixes = properties.getResourceSuffixes();
        if (locationSuffixes.isEmpty()) {
            return null;
        }
        String locationPrefix = properties.getResourceLocation();
        if (locationPrefix.startsWith("classpath:") || locationPrefix.startsWith("classpath*:")) {
            return new BaseAutoDeployResourceContribution(locationPrefix, locationSuffixes);
        }
        return null;
    }
}

