/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.ee;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.JMSConnectionFactoryMetaData;
import org.jboss.metadata.javaee.spec.PropertiesMetaData;
import org.jboss.metadata.parser.ee.Attribute;
import org.jboss.metadata.parser.ee.DescriptionsMetaDataParser;
import org.jboss.metadata.parser.ee.Element;
import org.jboss.metadata.parser.ee.PropertyMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;

public class JMSConnectionFactoryMetaDataParser
extends MetaDataElementParser {
    public static JMSConnectionFactoryMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        JMSConnectionFactoryMetaData metaData = new JMSConnectionFactoryMetaData();
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (JMSConnectionFactoryMetaDataParser.attributeHasNamespace(reader, i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    metaData.setId(value);
                    continue block16;
                }
                default: {
                    throw JMSConnectionFactoryMetaDataParser.unexpectedAttribute(reader, i);
                }
            }
        }
        DescriptionsImpl descriptions = new DescriptionsImpl();
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionsMetaDataParser.parse(reader, descriptions, propertyReplacer)) {
                if (metaData.getDescriptions() != null) continue;
                metaData.setDescriptions(descriptions);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NAME: {
                    metaData.setName(JMSConnectionFactoryMetaDataParser.getElementText(reader, propertyReplacer));
                    continue block17;
                }
                case INTERFACE_NAME: {
                    metaData.setInterfaceName(JMSConnectionFactoryMetaDataParser.getElementText(reader, propertyReplacer));
                    continue block17;
                }
                case CLASS_NAME: {
                    metaData.setClassName(JMSConnectionFactoryMetaDataParser.getElementText(reader, propertyReplacer));
                    continue block17;
                }
                case RESOURCE_ADAPTER: {
                    metaData.setResourceAdapter(JMSConnectionFactoryMetaDataParser.getElementText(reader, propertyReplacer));
                    continue block17;
                }
                case USER: {
                    metaData.setUser(JMSConnectionFactoryMetaDataParser.getElementText(reader, propertyReplacer));
                    continue block17;
                }
                case PASSWORD: {
                    metaData.setPassword(JMSConnectionFactoryMetaDataParser.getElementText(reader, propertyReplacer));
                    continue block17;
                }
                case CLIENT_ID: {
                    metaData.setClientId(JMSConnectionFactoryMetaDataParser.getElementText(reader, propertyReplacer));
                    continue block17;
                }
                case PROPERTY: {
                    PropertiesMetaData properties = metaData.getProperties();
                    if (properties == null) {
                        properties = new PropertiesMetaData();
                        metaData.setProperties(properties);
                    }
                    properties.add(PropertyMetaDataParser.parse(reader, propertyReplacer));
                    continue block17;
                }
                case TRANSACTIONAL: {
                    metaData.setTransactional(Boolean.valueOf(JMSConnectionFactoryMetaDataParser.getElementText(reader, propertyReplacer)));
                    continue block17;
                }
                case MAX_POOL_SIZE: {
                    metaData.setMaxPoolSize(Integer.valueOf(JMSConnectionFactoryMetaDataParser.getElementText(reader, propertyReplacer)));
                    continue block17;
                }
                case MIN_POOL_SIZE: {
                    metaData.setMinPoolSize(Integer.valueOf(JMSConnectionFactoryMetaDataParser.getElementText(reader, propertyReplacer)));
                    continue block17;
                }
            }
            throw JMSConnectionFactoryMetaDataParser.unexpectedElement(reader);
        }
        return metaData;
    }
}

