/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.DropCheckConstraintStatement;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropCheckConstraint", description="Drops an existing check constraint", priority=1, appliesTo={"checkConstraint"})
public class DropCheckConstraintChange
extends LicenseValidationChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String constraintName;

    @Override
    public ValidationErrors validate(Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase) {
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, this);
    }

    @DatabaseChangeProperty(mustEqualExisting="checkConstraint.table.catalog", since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String string) {
        this.catalogName = string;
    }

    @DatabaseChangeProperty(mustEqualExisting="checkConstraint.table.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    @DatabaseChangeProperty(mustEqualExisting="checkConstraint.table", description="Name of the table to drop the check constraint from")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    @DatabaseChangeProperty(mustEqualExisting="checkConstraint", description="Name of check constraint to drop")
    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new DropCheckConstraintStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getConstraintName())};
    }

    @Override
    public String getConfirmationMessage() {
        return "Check constraint " + this.getConstraintName() + " dropped from " + this.getTableName();
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }
}

