/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseBasicForecastRule;
import com.datical.liquibase.ext.util.DatabaseObjectUtils;
import java.util.Collections;
import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;
import liquibase.util.StringUtil;

public class TableMustHaveAComment
extends AbstractLiquibaseBasicForecastRule {
    public TableMustHaveAComment() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.DATABASE);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject) {
        if (databaseObject instanceof Table && StringUtil.isEmpty(((Table)databaseObject).getRemarks())) {
            this.addFailureRuleIteration(databaseObject, String.format("Table %s found without comment. Liquibase recommends tables have a comment to prevent siloed knowledge and to ensure table's purpose is easily understood by others. (Note: This is not a check for a Liquibase changelog comment.)", DatabaseObjectUtils.buildFullyQualifiedName(databaseObject)), null);
        }
        return this.returnAtEndOfRule(databaseObject, null);
    }

    @Override
    public String getDescription() {
        return "This database check flags any table which does not have a comment. (Note: This is not a check for a Liquibase changelog comment.)";
    }

    @Override
    public String getShortName() {
        return "TableCommentCheck";
    }

    @Override
    public int getPriority() {
        return 500;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }
}

