/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;

public enum Constraint {
    NOT_NULL(iterator -> {
        if ((iterator = ((Relation)((Object)iterator)).getColumns()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                if (column.isNullable().booleanValue()) continue;
                hashSet.add(column.getName());
            }
            return hashSet;
        }
        return Collections.emptySet();
    }),
    UNIQUE(iterator -> {
        if ((iterator = ((Table)((Object)iterator)).getUniqueConstraints()) != null) {
            HashSet hashSet = new HashSet();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                UniqueConstraint uniqueConstraint = (UniqueConstraint)iterator.next();
                hashSet.addAll(uniqueConstraint.getColumns().stream().map(Column::getName).collect(Collectors.toList()));
            }
            return hashSet;
        }
        return Collections.emptySet();
    }),
    PRIMARYKEY(abstractDatabaseObject -> {
        if ((abstractDatabaseObject = ((Table)abstractDatabaseObject).getPrimaryKey()) != null) {
            return ((PrimaryKey)abstractDatabaseObject).getColumns().stream().map(Column::getName).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }),
    FOREIGNKEY(iterator -> {
        if ((iterator = ((Table)((Object)iterator)).getOutgoingForeignKeys()) != null) {
            HashSet hashSet = new HashSet();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ForeignKey foreignKey = (ForeignKey)iterator.next();
                hashSet.addAll(foreignKey.getForeignKeyColumns().stream().map(Column::getName).collect(Collectors.toSet()));
            }
            return hashSet;
        }
        return Collections.emptySet();
    }),
    DEFAULT(iterator -> {
        if ((iterator = ((Relation)((Object)iterator)).getColumns()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                if (column.getDefaultValue() == null) continue;
                hashSet.add(column.getName());
            }
            return hashSet;
        }
        return Collections.emptySet();
    });

    private final Function<Table, Set<String>> getColumnNamesCallback;

    private Constraint(Function<Table, Set<String>> function) {
        this.getColumnNamesCallback = function;
    }

    public final Set<String> getColumnNames(Table table) {
        return this.getColumnNamesCallback.apply(table);
    }
}

