/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.init;

import com.datical.liquibase.ext.checks.config.ChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.command.init.InitHubCommandStep$CustomResourceAccessor;
import com.datical.liquibase.ext.command.init.InitProjectCommandStep;
import com.datical.liquibase.ext.init.InitProjectUtil;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResults;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.command.core.RegisterChangelogCommandStep;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.core.DefaultsFileValueProvider;
import liquibase.exception.ChangeLogAlreadyRegisteredException;
import liquibase.exception.CommandExecutionException;
import liquibase.hub.HubConfiguration;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.model.CoreInitOnboardingResponse;
import liquibase.hub.model.Operation;
import liquibase.hub.model.OperationEvent;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.util.FileUtil;
import liquibase.util.StringUtil;
import org.yaml.snakeyaml.Yaml;

public class InitHubCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"init", "hub"};
    public static final CommandArgumentDefinition<String> INIT_HUB_PROJECT_DIR_ARG;
    public static final CommandArgumentDefinition<String> INIT_HUB_TOKEN_ARG;
    public static final CommandArgumentDefinition<String> INIT_HUB_CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> INIT_HUB_URL_ARG;
    public static final CommandArgumentDefinition<String> INIT_HUB_USERNAME_ARG;
    public static final CommandArgumentDefinition<String> INIT_HUB_PASSWORD_ARG;
    private final Yaml yaml = new Yaml();

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void run(CommandResultsBuilder commandResultsBuilder) {
        CommandScope commandScope = commandResultsBuilder.getCommandScope();
        Object object = commandScope.getConfiguredValue(INIT_HUB_TOKEN_ARG).getValue().trim().toUpperCase();
        if (((String)object).length() != 7) {
            throw new CommandExecutionException("The token must be 7 characters in length.");
        }
        if (!Pattern.compile("[A-Z0-9]*").matcher((CharSequence)object).matches()) {
            throw new CommandExecutionException("The token must be alphanumeric.");
        }
        Object object2 = Scope.getCurrentScope().getSingleton(HubServiceFactory.class);
        if (HubConfiguration.LIQUIBASE_HUB_MODE.getCurrentValue() == HubConfiguration.HubMode.OFF || !((HubServiceFactory)object2).isOnline()) {
            throw new LiquibaseHubException("The command 'init hub' requires liquibase.hub.mode to be 'all' or 'meta', but it is currently set to 'off'. Please update this property in the defaults file, Environment variable or other method. Learn more at https://docs.liquibase.com");
        }
        object2 = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        object = object2.validateOnboardingToken((String)object);
        Map<String, Object> map = Collections.singletonMap(HubConfiguration.LIQUIBASE_HUB_API_KEY.getKey(), ((CoreInitOnboardingResponse)object).getApiKey().getKey());
        Scope.child(map, () -> this.lambda$run$1((CoreInitOnboardingResponse)object, (HubService)object2, commandScope, map, commandResultsBuilder));
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    private void sendOperationEvent(HubService hubService, String string, Operation operation, UUID uUID) {
        this.sendOperationEvent(hubService, string, operation, uUID, "PASS");
    }

    private void sendOperationEvent(HubService hubService, String string, Operation operation, UUID uUID, String string2) {
        OperationEvent operationEvent = new OperationEvent();
        operationEvent.setEventType(string);
        operationEvent.setStartDate(new Date());
        operationEvent.setEndDate(new Date());
        OperationEvent.OperationEventStatus operationEventStatus = new OperationEvent.OperationEventStatus();
        operationEventStatus.setOperationEventStatusType(string2);
        operationEventStatus.setStatusMessage("Hub Connection Established");
        operationEvent.setOperationEventStatus(operationEventStatus);
        hubService.sendOperationEvent(operation, operationEvent, uUID);
        Scope.getCurrentScope().getLog(this.getClass()).fine(string + " operation event successfully sent to hub");
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Command used to complete Hub and Liquibase setup. Requires a \"token\" available from hub.liquibase.com with a valid user account. Updates the specified liquibase.properties with a valid Hub API Key, and registers the specified changelog file wih Hub, enabling secure monitoring and sharing of local Liquibase activity within an organization.");
        commandDefinition.setGroupShortDescription(new String[]{"init"}, "Init commands");
    }

    private static void updateDefaultsFile(File file, String string, boolean bl2, String string2) {
        String string3;
        String string4 = FileUtil.getContents(file);
        String string5 = string3 = StringUtil.isEmpty(string2) ? string4 : string2;
        if (string4 == null) {
            throw new CommandExecutionException("Cannot load contents of defaults file.");
        }
        if (StringUtil.isNotEmpty(string2) || bl2) {
            ChecksFileAccessor.makeBackup(InitProjectUtil.calcBackupFile(file), string4, null, false);
            InitProjectUtil.outputBackedUpDefaultsFileMessage(file.getAbsolutePath());
        }
        FileUtil.write(InitProjectUtil.replaceProperty("liquibase.hub.apiKey", string, string3, false, false, true, false, false), file, false);
    }

    private /* synthetic */ void lambda$run$1(CoreInitOnboardingResponse object, HubService hubService, CommandScope commandScope, Map hashMap, CommandResultsBuilder commandResultsBuilder) {
        UUID uUID = ((CoreInitOnboardingResponse)object).getOrganization().getId();
        Operation operation = hubService.createOperationInOrganization("INIT", "init-hub", uUID);
        Scope.getCurrentScope().getLog(this.getClass()).fine("init operation successfully sent to hub");
        Scope.getCurrentScope().getLog(this.getClass()).fine(this.yaml.dump((Object)operation));
        Scope.getCurrentScope().getUI().sendMessage("Hub connection established.");
        this.sendOperationEvent(hubService, "START", operation, uUID);
        ConfiguredValue<String> configuredValue = commandScope.getConfiguredValue(INIT_HUB_PROJECT_DIR_ARG);
        String string = configuredValue.getValue();
        HashMap<String, Object> hashMap2 = new File(string);
        ConfiguredValue<String> configuredValue2 = LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getCurrentConfiguredValue();
        ConfiguredValue<String> configuredValue3 = configuredValue2.getValue();
        configuredValue3 = new File((File)((Object)hashMap2), (String)((Object)configuredValue3));
        Object object2 = InitProjectUtil.findChangeLogsInProjectDir((File)((Object)hashMap2));
        CommandResults commandResults = null;
        boolean bl2 = ((File)((Object)configuredValue3)).exists();
        if (!bl2 || ((File[])object2).length == 0) {
            CommandScope commandScope2 = new CommandScope(InitProjectCommandStep.COMMAND_NAME[0], InitProjectCommandStep.COMMAND_NAME[1]);
            commandScope2.addArgumentValue(InitProjectCommandStep.INIT_PROJECT_DIR_ARG, ((File)((Object)hashMap2)).getAbsolutePath());
            hashMap2 = new HashMap<String, Object>(hashMap);
            hashMap2.put("shouldBackupDefaultsFile", Boolean.FALSE);
            commandResults = Scope.child(hashMap2, commandScope2::execute);
            if (commandResults.getResult(InitProjectCommandStep.INIT_DEFAULTS_FILE_ARG.getName()) != null) {
                configuredValue3 = (File)commandResults.getResult(InitProjectCommandStep.INIT_DEFAULTS_FILE_ARG.getName());
            }
        }
        boolean bl3 = true;
        if (!((File)((Object)configuredValue3)).exists()) {
            Scope.getCurrentScope().getUI().sendMessage("Cannot add Hub API Key to defaults file, because no defaults file can be found.");
            this.sendOperationEvent(hubService, "ENVIRONMENT_SETUP", operation, uUID, "FAIL");
            bl3 = false;
        } else {
            hashMap2 = commandResults == null ? null : (String)commandResults.getResult("modifiedDefaultsFileContents");
            InitHubCommandStep.updateDefaultsFile((File)((Object)configuredValue3), ((CoreInitOnboardingResponse)object).getApiKey().getKey(), bl2, (String)((Object)hashMap2));
            this.sendOperationEvent(hubService, "ENVIRONMENT_SETUP", operation, uUID);
        }
        hashMap2 = new RegisterChangelogCommandStep();
        object = null;
        if (commandResults != null && commandResults.getResult(InitProjectCommandStep.INIT_CHANGELOG_FILE_ARG.getName()) != null) {
            object = (String)commandResults.getResult(InitProjectCommandStep.INIT_CHANGELOG_FILE_ARG.getName());
        } else {
            configuredValue3 = commandScope.getConfiguredValue(INIT_HUB_CHANGELOG_FILE_ARG);
            if (configuredValue3.getProvidedValue().getProvider() instanceof DefaultsFileValueProvider) {
                object = configuredValue3.getValue();
            } else if (object2 != null && ((File[])object2).length > 0) {
                object = object2[0].getPath();
            }
        }
        boolean bl4 = true;
        if (object == null) {
            Scope.getCurrentScope().getUI().sendMessage("Changelog file does not exist, and thus cannot be registered with Hub.");
            this.sendOperationEvent(hubService, "REGISTER_CHANGELOG", operation, uUID, "FAIL");
            bl4 = false;
        } else {
            hashMap = new HashMap<String, Object>(hashMap);
            object = InitProjectUtil.removeDotsFromPath((String)object);
            object2 = new InitHubCommandStep$CustomResourceAccessor((String)object, null);
            Object object3 = Scope.getCurrentScope().getResourceAccessor();
            if (object3 instanceof CompositeResourceAccessor) {
                ((CompositeResourceAccessor)object3).addResourceAccessor((ResourceAccessor)object2);
            } else {
                object3 = new CompositeResourceAccessor(new ResourceAccessor[]{object3});
                ((CompositeResourceAccessor)object3).addResourceAccessor((ResourceAccessor)object2);
                hashMap.put(Scope.Attr.resourceAccessor.toString(), object3);
            }
            try {
                Scope.child(hashMap, () -> InitHubCommandStep.lambda$null$0(hashMap2, (String)object, commandResultsBuilder));
                ((CompositeResourceAccessor)object3).removeResourceAccessor((ResourceAccessor)object2);
                this.sendOperationEvent(hubService, "REGISTER_CHANGELOG", operation, uUID);
            }
            catch (CommandExecutionException commandExecutionException) {
                object3 = commandExecutionException;
                object = commandExecutionException.getCause();
                this.sendOperationEvent(hubService, "REGISTER_CHANGELOG", operation, uUID, "FAIL");
                bl4 = false;
                if (!(object instanceof ChangeLogAlreadyRegisteredException) || ((ChangeLogAlreadyRegisteredException)object).getHubChangeLog() == null) {
                    throw object3;
                }
                Scope.getCurrentScope().getUI().sendMessage(((Throwable)object3).getMessage());
                Scope.getCurrentScope().getLog(this.getClass()).info(((Throwable)object3).getMessage());
            }
        }
        this.sendOperationEvent(hubService, "COMPLETE", operation, uUID);
        boolean bl5 = InitProjectUtil.wasH2Used(commandScope.getConfiguredValue(INIT_HUB_URL_ARG), commandScope.getConfiguredValue(INIT_HUB_USERNAME_ARG), commandScope.getConfiguredValue(INIT_HUB_PASSWORD_ARG));
        if ((bl3 || bl4) && (bl5 || commandResults != null && commandResults.getResult("usedH2") != null)) {
            InitProjectCommandStep.outputEndInstructions(configuredValue.wasDefaultValueUsed(), configuredValue2, string, bl5 || (Boolean)commandResults.getResult("usedH2") != false);
        }
    }

    private static /* synthetic */ void lambda$null$0(RegisterChangelogCommandStep registerChangelogCommandStep, String string, CommandResultsBuilder commandResultsBuilder) {
        registerChangelogCommandStep.doRegisterChangelog(string, null, null, commandResultsBuilder, true);
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        INIT_HUB_PROJECT_DIR_ARG = commandBuilder.argument("projectDir", String.class).description("An optional parameter used to specify the directory containing files (existing or to be auto-created) to be used with Liquibase").defaultValue("./").build();
        INIT_HUB_TOKEN_ARG = commandBuilder.argument("token", String.class).description("A required one-time-use code to connect your local Liquibase usage to your existing Liquibase Hub user account. Token is available to registered Hub users at https://hub.liquibase.com.").required().build();
        INIT_HUB_CHANGELOG_FILE_ARG = commandBuilder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).description("Relative or fully qualified path to the changelog file").defaultValue((String)DynamicRuleParameterEnum.SAMPLE_CHANGELOG_NAME.defaultValue).hidden().build();
        INIT_HUB_URL_ARG = commandBuilder.argument(CommonArgumentNames.URL, String.class).description("The JDBC database connection URL").defaultValue((String)DynamicRuleParameterEnum.JDBC_URL.defaultValue).hidden().build();
        INIT_HUB_USERNAME_ARG = commandBuilder.argument(CommonArgumentNames.USERNAME, String.class).description("Username to use to connect to the database").defaultValue((String)DynamicRuleParameterEnum.USERNAME.defaultValue).hidden().build();
        INIT_HUB_PASSWORD_ARG = commandBuilder.argument(CommonArgumentNames.PASSWORD, String.class).description("Password to use to connect to the database").defaultValue((String)DynamicRuleParameterEnum.PASSWORD.defaultValue).setValueObfuscator(ConfigurationValueObfuscator.STANDARD).hidden().build();
    }
}

