/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import com.datical.liquibase.ext.command.checks.LazyDatabaseSnapshot;
import com.datical.liquibase.ext.rules.annotation.Rule;
import com.datical.liquibase.ext.rules.api.Fact;
import com.datical.liquibase.ext.rules.api.FactEnum;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.api.LiquibaseRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule$SupportedChangesetFormats;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import com.datical.liquibase.ext.rules.core.RuleIteration$FailureReason;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.core.SQLFileChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.license.pro.LicenseTier;
import liquibase.logging.Logger;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

@Rule
public abstract class AbstractLiquibaseRule
implements LiquibaseRule {
    private final UUID id = UUID.nameUUIDFromBytes(StringUtil.getBytesWithEncoding(this.getClass().getName()));
    private SeverityEnum severity;
    private static final ConcurrentHashMap<AbstractSQLChange, String> sqlContentsCache = new ConcurrentHashMap();
    private final Map<ChangeSet, LiquibaseRuleResult> results = new LinkedHashMap<ChangeSet, LiquibaseRuleResult>();
    private final Map<DatabaseObject, LiquibaseRuleResult> databaseResults = new LinkedHashMap<DatabaseObject, LiquibaseRuleResult>();
    public static final int MAX_SHORT_NAME_LENGTH = 64;

    @Override
    public final UUID getId() {
        return this.id;
    }

    @Override
    public final SeverityEnum getSeverity() {
        return this.severity;
    }

    @Override
    public final void setSeverity(SeverityEnum severityEnum) {
        this.severity = severityEnum;
    }

    @Override
    public Map<ChangeSet, LiquibaseRuleResult> getResults() {
        return this.results;
    }

    @Override
    public Map<DatabaseObject, LiquibaseRuleResult> getDatabaseResults() {
        return this.databaseResults;
    }

    private boolean putResult(ChangeSet changeSet, LiquibaseRuleResult liquibaseRuleResult) {
        Objects.requireNonNull(liquibaseRuleResult);
        this.results.put(changeSet, liquibaseRuleResult);
        return !this.results.get(changeSet).hasRuleSucceeded();
    }

    private boolean putResult(DatabaseObject databaseObject, LiquibaseRuleResult liquibaseRuleResult) {
        Objects.requireNonNull(liquibaseRuleResult);
        this.databaseResults.put(databaseObject, liquibaseRuleResult);
        return !this.databaseResults.get(databaseObject).hasRuleSucceeded();
    }

    @Override
    public List<String> getSupportedChangesetFormats() {
        if (this.getScope().contains((Object)ScopeEnum.DATABASE) && this.getScope().size() == 1) {
            return Collections.emptyList();
        }
        return AbstractLiquibaseRule$SupportedChangesetFormats.ALL;
    }

    public boolean putResultSuccessful(ChangeSet changeSet, boolean bl2, DynamicRule dynamicRule) {
        if (bl2) {
            return this.putResult(changeSet, new LiquibaseRuleResult(this, dynamicRule, new RuleIteration(true)));
        }
        return this.putResult(changeSet, new LiquibaseRuleResult(this));
    }

    public boolean putResultSuccessful(DatabaseObject databaseObject, boolean bl2, DynamicRule dynamicRule) {
        if (bl2) {
            return this.putResult(databaseObject, new LiquibaseRuleResult(this, dynamicRule, new RuleIteration(true)));
        }
        return this.putResult(databaseObject, new LiquibaseRuleResult(this));
    }

    public boolean putResultUnsuccessful(ChangeSet changeSet, String string) {
        return this.putResultUnsuccessful(changeSet, string, null);
    }

    public boolean putResultUnsuccessful(ChangeSet changeSet, String string, DynamicRule dynamicRule) {
        return this.putResult(changeSet, new LiquibaseRuleResult(this, dynamicRule, new RuleIteration(false, string)));
    }

    public boolean putResultUnsuccessful(DatabaseObject databaseObject, String string) {
        return this.putResultUnsuccessful(databaseObject, string, null);
    }

    public boolean putResultUnsuccessful(DatabaseObject databaseObject, String string, DynamicRule dynamicRule) {
        return this.putResult(databaseObject, new LiquibaseRuleResult(this, dynamicRule, new RuleIteration(false, string)));
    }

    public void addFailureRuleIteration(ChangeSet changeSet, String string, DynamicRule dynamicRule) {
        this.addFailureRuleIteration(changeSet, new RuleIteration(false, string), dynamicRule);
    }

    public void addFailureRuleIteration(DatabaseObject databaseObject, String string, DynamicRule dynamicRule) {
        this.addFailureRuleIteration(databaseObject, new RuleIteration(false, string), dynamicRule);
    }

    public void addFailureRuleIteration(ChangeSet changeSet, String string, RuleIteration$FailureReason ruleIteration$FailureReason, DynamicRule dynamicRule) {
        this.addFailureRuleIteration(changeSet, new RuleIteration(ruleIteration$FailureReason, string), dynamicRule);
    }

    public void addFailureRuleIteration(DatabaseObject databaseObject, String string, RuleIteration$FailureReason ruleIteration$FailureReason, DynamicRule dynamicRule) {
        this.addFailureRuleIteration(databaseObject, new RuleIteration(ruleIteration$FailureReason, string), dynamicRule);
    }

    private void addFailureRuleIteration(ChangeSet changeSet, RuleIteration ruleIteration, DynamicRule dynamicRule) {
        if (this.results.containsKey(changeSet)) {
            this.results.get(changeSet).getExecutions().add(ruleIteration);
            return;
        }
        this.results.put(changeSet, new LiquibaseRuleResult(this, dynamicRule, ruleIteration));
    }

    private void addFailureRuleIteration(DatabaseObject databaseObject, RuleIteration ruleIteration, DynamicRule dynamicRule) {
        if (this.databaseResults.containsKey(databaseObject)) {
            this.databaseResults.get(databaseObject).getExecutions().add(ruleIteration);
            return;
        }
        this.databaseResults.put(databaseObject, new LiquibaseRuleResult(this, dynamicRule, ruleIteration));
    }

    public boolean returnAtEndOfRule(ChangeSet changeSet, DynamicRule dynamicRule) {
        if (this.getResults().isEmpty()) {
            return this.putResultSuccessful(changeSet, true, dynamicRule);
        }
        if (!this.getResults().containsKey(changeSet)) {
            return this.putResultSuccessful(changeSet, true, dynamicRule);
        }
        if (this.getResults().get(changeSet).hasRuleSucceeded()) {
            return this.putResultSuccessful(changeSet, true, dynamicRule);
        }
        return !this.getResults().get(changeSet).hasRuleSucceeded();
    }

    public boolean returnAtEndOfRule(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        if (this.getDatabaseResults().isEmpty()) {
            return this.putResultSuccessful(databaseObject, true, dynamicRule);
        }
        if (!this.getDatabaseResults().containsKey(databaseObject)) {
            return this.putResultSuccessful(databaseObject, true, dynamicRule);
        }
        if (this.getDatabaseResults().get(databaseObject).hasRuleSucceeded()) {
            return this.putResultSuccessful(databaseObject, true, dynamicRule);
        }
        return !this.getDatabaseResults().get(databaseObject).hasRuleSucceeded();
    }

    @Override
    public String getName() {
        return StringUtil.upperCaseFirst(StringUtil.join(StringUtil.splitCamelCase(this.getClass().getSimpleName()), " ").toLowerCase());
    }

    @Override
    public abstract String getDescription();

    public abstract String getShortName();

    @Override
    public abstract int getPriority();

    public abstract List<RuleParameter<?>> getParameters();

    public String prettyPrintParameters() {
        if (this.isConfigurable()) {
            return StringUtil.join(this.getParameters().stream().map(ruleParameter -> ruleParameter.toString() + " = " + ruleParameter.getDefaultValue()).collect(Collectors.toList()), System.lineSeparator());
        }
        return "<None>";
    }

    public boolean isConfigurable() {
        return this.getParameters() != null && !this.getParameters().isEmpty();
    }

    @Override
    public void execute(Facts facts) {
    }

    public String generateErrorMessage(String string) {
        Objects.requireNonNull(string);
        return "Change Set " + string.trim();
    }

    public List<ChangeSet> getChangeSetFromFacts(Facts object) {
        if (object == null) {
            return null;
        }
        if ((object = ((Facts)object).getFact(FactEnum.CHANGESETS.toString())) != null) {
            return (List)((Fact)object).getValue();
        }
        return null;
    }

    public Database getDatabaseFromFacts(Facts object) {
        if (object == null) {
            return null;
        }
        if ((object = ((Facts)object).getFact(FactEnum.DATABASE.toString())) != null) {
            return (Database)((Fact)object).getValue();
        }
        return null;
    }

    public LazyDatabaseSnapshot getSnapshotFromFacts(Facts object) {
        if (object == null) {
            return null;
        }
        if ((object = ((Facts)object).getFact(FactEnum.DATABASE_SNAPSHOT.toString())) != null) {
            return (LazyDatabaseSnapshot)((Fact)object).getValue();
        }
        return null;
    }

    public boolean shouldBeEvaluated(ChangeSet changeSet) {
        if (changeSet != null) {
            int n2 = 0;
            int n3 = 0;
            Object object = changeSet.getChanges().iterator();
            while (object.hasNext()) {
                if (object.next() instanceof AbstractSQLChange) {
                    ++n3;
                    continue;
                }
                ++n2;
            }
            object = this.getSupportedChangesetFormats();
            boolean bl2 = false;
            boolean bl3 = false;
            if (n3 > 0 && !object.containsAll(AbstractLiquibaseRule$SupportedChangesetFormats.UNMODELED)) {
                this.addFailureRuleIteration(changeSet, new RuleIteration(RuleIteration$FailureReason.INVALID_CHANGELOG_FILE_TYPE), null);
                bl2 = true;
            }
            if (n2 > 0 && !object.containsAll(AbstractLiquibaseRule$SupportedChangesetFormats.MODELED)) {
                this.addFailureRuleIteration(changeSet, new RuleIteration(RuleIteration$FailureReason.INVALID_CHANGELOG_FILE_TYPE), null);
                bl3 = true;
            }
            return !(n3 == 0 && bl3 || n2 == 0 && bl2 || bl3 && bl2);
        }
        return true;
    }

    public boolean shouldBeEvaluated(DatabaseObject databaseObject) {
        return true;
    }

    public AbstractConfigurableRule getAbstractConfigurableRuleFromFacts(Facts object) {
        if (object == null) {
            return null;
        }
        object = ((Facts)object).getFact(FactEnum.INSTANCE_SETTINGS.toString());
        Objects.requireNonNull(object);
        return (AbstractConfigurableRule)((Fact)object).getValue();
    }

    public final boolean hasDefaultParameterValues() {
        if (this.getParameters() != null) {
            Iterator<RuleParameter<?>> iterator = this.getParameters().iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getDefaultValue() != null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public LicenseTier getRequiredLicense(ScopeEnum scopeEnum) {
        if (ScopeEnum.DATABASE == scopeEnum) {
            return LicenseTier.LABS;
        }
        return LicenseTier.PRO;
    }

    public LicenseTier getMinimumAllowableLicense() {
        List<ScopeEnum> list = this.getScope();
        if (list != null) {
            ArrayList<LicenseTier> arrayList = new ArrayList<LicenseTier>(list.size());
            for (ScopeEnum scopeEnum : list) {
                LicenseTier enum_ = this.getRequiredLicense(scopeEnum);
                if (enum_ == null) continue;
                arrayList.add(enum_);
            }
            return arrayList.stream().min(Comparator.comparingInt(LicenseTier::getValue)).orElse(LicenseTier.COMMUNITY);
        }
        return LicenseTier.COMMUNITY;
    }

    public final String getSql(AbstractSQLChange abstractSQLChange) {
        if (abstractSQLChange instanceof SQLFileChange) {
            Boolean bl2 = Scope.getCurrentScope().get(ChecksRunCommandStep.CACHE_CHANGELOG_FILE_CONTENTS.getName(), Boolean.TRUE);
            Logger logger = Scope.getCurrentScope().getLog(this.getClass());
            if (bl2.booleanValue() && sqlContentsCache.containsKey(abstractSQLChange)) {
                logger.fine("Cache hit for ".concat(String.valueOf(abstractSQLChange)));
                return sqlContentsCache.get(abstractSQLChange);
            }
            String string = abstractSQLChange.getSql();
            if (!bl2.booleanValue()) {
                logger.fine("Cache miss for " + abstractSQLChange + " and not caching, because caching is disabled");
            } else {
                logger.fine("Cache miss for ".concat(String.valueOf(abstractSQLChange)));
                sqlContentsCache.put(abstractSQLChange, string);
            }
            return string;
        }
        return abstractSQLChange.getSql();
    }

    @Override
    public int compareTo(com.datical.liquibase.ext.rules.api.Rule rule) {
        if (this.getPriority() < rule.getPriority()) {
            return -1;
        }
        if (this.getPriority() > rule.getPriority()) {
            return 1;
        }
        return this.getName().compareTo(rule.getName());
    }

    public boolean isEnabledByDefault() {
        return this.hasDefaultParameterValues();
    }
}

