/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.yaml;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.Scope;
import liquibase.logging.Logger;
import liquibase.parser.LiquibaseParser;
import liquibase.resource.ResourceAccessor;
import liquibase.util.SnakeYamlUtil;
import org.yaml.snakeyaml.LoaderOptions;

public abstract class YamlParser
implements LiquibaseParser {
    protected Logger log = Scope.getCurrentScope().getLog(this.getClass());
    public static final Set<String> SUPPORTED_EXTENSIONS = new HashSet<String>(Arrays.asList("yaml", "yml"));

    public static LoaderOptions createLoaderOptions() {
        LoaderOptions options = new LoaderOptions();
        SnakeYamlUtil.setCodePointLimitSafely(options, Integer.MAX_VALUE);
        SnakeYamlUtil.setProcessCommentsSafely(options, false);
        options.setAllowRecursiveKeys(false);
        return options;
    }

    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        for (String extension : this.getSupportedFileExtensions()) {
            if (!changeLogFile.toLowerCase().endsWith("." + extension)) continue;
            return true;
        }
        return false;
    }

    protected String[] getSupportedFileExtensions() {
        return SUPPORTED_EXTENSIONS.toArray(new String[0]);
    }

    @Override
    public int getPriority() {
        return 1;
    }
}

