/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.openai;

import io.micrometer.observation.ObservationRegistry;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.ai.autoconfigure.chat.model.ToolCallingAutoConfiguration;
import org.springframework.ai.autoconfigure.openai.OpenAiAudioSpeechProperties;
import org.springframework.ai.autoconfigure.openai.OpenAiAudioTranscriptionProperties;
import org.springframework.ai.autoconfigure.openai.OpenAiChatProperties;
import org.springframework.ai.autoconfigure.openai.OpenAiConnectionProperties;
import org.springframework.ai.autoconfigure.openai.OpenAiEmbeddingProperties;
import org.springframework.ai.autoconfigure.openai.OpenAiImageProperties;
import org.springframework.ai.autoconfigure.openai.OpenAiModerationProperties;
import org.springframework.ai.autoconfigure.openai.OpenAiParentProperties;
import org.springframework.ai.autoconfigure.retry.SpringAiRetryAutoConfiguration;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.image.observation.ImageModelObservationConvention;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.model.function.DefaultFunctionCallbackResolver;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.openai.OpenAiAudioSpeechModel;
import org.springframework.ai.openai.OpenAiAudioTranscriptionModel;
import org.springframework.ai.openai.OpenAiChatModel;
import org.springframework.ai.openai.OpenAiEmbeddingModel;
import org.springframework.ai.openai.OpenAiImageModel;
import org.springframework.ai.openai.OpenAiModerationModel;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.openai.api.OpenAiAudioApi;
import org.springframework.ai.openai.api.OpenAiImageApi;
import org.springframework.ai.openai.api.OpenAiModerationApi;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.function.client.WebClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, WebClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class, ToolCallingAutoConfiguration.class})
@ConditionalOnClass(value={OpenAiApi.class})
@EnableConfigurationProperties(value={OpenAiConnectionProperties.class, OpenAiChatProperties.class, OpenAiEmbeddingProperties.class, OpenAiImageProperties.class, OpenAiAudioTranscriptionProperties.class, OpenAiAudioSpeechProperties.class, OpenAiModerationProperties.class})
@ImportAutoConfiguration(classes={SpringAiRetryAutoConfiguration.class, RestClientAutoConfiguration.class, WebClientAutoConfiguration.class, ToolCallingAutoConfiguration.class})
public class OpenAiAutoConfiguration {
    @NotNull
    private static ResolvedConnectionProperties resolveConnectionProperties(OpenAiParentProperties commonProperties, OpenAiParentProperties modelProperties, String modelType) {
        String baseUrl = StringUtils.hasText((String)modelProperties.getBaseUrl()) ? modelProperties.getBaseUrl() : commonProperties.getBaseUrl();
        String apiKey = StringUtils.hasText((String)modelProperties.getApiKey()) ? modelProperties.getApiKey() : commonProperties.getApiKey();
        String projectId = StringUtils.hasText((String)modelProperties.getProjectId()) ? modelProperties.getProjectId() : commonProperties.getProjectId();
        String organizationId = StringUtils.hasText((String)modelProperties.getOrganizationId()) ? modelProperties.getOrganizationId() : commonProperties.getOrganizationId();
        HashMap<String, List<String>> connectionHeaders = new HashMap<String, List<String>>();
        if (StringUtils.hasText((String)projectId)) {
            connectionHeaders.put("OpenAI-Project", List.of(projectId));
        }
        if (StringUtils.hasText((String)organizationId)) {
            connectionHeaders.put("OpenAI-Organization", List.of(organizationId));
        }
        Assert.hasText((String)baseUrl, (String)("OpenAI base URL must be set.  Use the connection property: spring.ai.openai.base-url or spring.ai.openai." + modelType + ".base-url property."));
        Assert.hasText((String)apiKey, (String)("OpenAI API key must be set. Use the connection property: spring.ai.openai.api-key or spring.ai.openai." + modelType + ".api-key property."));
        return new ResolvedConnectionProperties(baseUrl, apiKey, (MultiValueMap<String, String>)CollectionUtils.toMultiValueMap(connectionHeaders));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.openai.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public OpenAiChatModel openAiChatModel(OpenAiConnectionProperties commonProperties, OpenAiChatProperties chatProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ObjectProvider<WebClient.Builder> webClientBuilderProvider, ToolCallingManager toolCallingManager, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention) {
        OpenAiApi openAiApi = this.openAiApi(chatProperties, commonProperties, (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder), (WebClient.Builder)webClientBuilderProvider.getIfAvailable(WebClient::builder), responseErrorHandler, "chat");
        OpenAiChatModel chatModel = OpenAiChatModel.builder().openAiApi(openAiApi).defaultOptions(chatProperties.getOptions()).toolCallingManager(toolCallingManager).retryTemplate(retryTemplate).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP)).build();
        observationConvention.ifAvailable(arg_0 -> ((OpenAiChatModel)chatModel).setObservationConvention(arg_0));
        return chatModel;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.openai.embedding", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public OpenAiEmbeddingModel openAiEmbeddingModel(OpenAiConnectionProperties commonProperties, OpenAiEmbeddingProperties embeddingProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ObjectProvider<WebClient.Builder> webClientBuilderProvider, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<EmbeddingModelObservationConvention> observationConvention) {
        OpenAiApi openAiApi = this.openAiApi(embeddingProperties, commonProperties, (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder), (WebClient.Builder)webClientBuilderProvider.getIfAvailable(WebClient::builder), responseErrorHandler, "embedding");
        OpenAiEmbeddingModel embeddingModel = new OpenAiEmbeddingModel(openAiApi, embeddingProperties.getMetadataMode(), embeddingProperties.getOptions(), retryTemplate, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((OpenAiEmbeddingModel)embeddingModel).setObservationConvention(arg_0));
        return embeddingModel;
    }

    private OpenAiApi openAiApi(OpenAiChatProperties chatProperties, OpenAiConnectionProperties commonProperties, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler, String modelType) {
        ResolvedConnectionProperties resolved = OpenAiAutoConfiguration.resolveConnectionProperties(commonProperties, chatProperties, modelType);
        return OpenAiApi.builder().baseUrl(resolved.baseUrl()).apiKey((ApiKey)new SimpleApiKey(resolved.apiKey())).headers(resolved.headers()).completionsPath(chatProperties.getCompletionsPath()).embeddingsPath("/v1/embeddings").restClientBuilder(restClientBuilder).webClientBuilder(webClientBuilder).responseErrorHandler(responseErrorHandler).build();
    }

    private OpenAiApi openAiApi(OpenAiEmbeddingProperties embeddingProperties, OpenAiConnectionProperties commonProperties, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler, String modelType) {
        ResolvedConnectionProperties resolved = OpenAiAutoConfiguration.resolveConnectionProperties(commonProperties, embeddingProperties, modelType);
        return OpenAiApi.builder().baseUrl(resolved.baseUrl()).apiKey((ApiKey)new SimpleApiKey(resolved.apiKey())).headers(resolved.headers()).completionsPath("/v1/chat/completions").embeddingsPath(embeddingProperties.getEmbeddingsPath()).restClientBuilder(restClientBuilder).webClientBuilder(webClientBuilder).responseErrorHandler(responseErrorHandler).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.openai.image", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public OpenAiImageModel openAiImageModel(OpenAiConnectionProperties commonProperties, OpenAiImageProperties imageProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, RetryTemplate retryTemplate, ResponseErrorHandler responseErrorHandler, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ImageModelObservationConvention> observationConvention) {
        ResolvedConnectionProperties resolved = OpenAiAutoConfiguration.resolveConnectionProperties(commonProperties, imageProperties, "image");
        OpenAiImageApi openAiImageApi = OpenAiImageApi.builder().baseUrl(resolved.baseUrl()).apiKey((ApiKey)new SimpleApiKey(resolved.apiKey())).headers(resolved.headers()).restClientBuilder((RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder)).responseErrorHandler(responseErrorHandler).build();
        OpenAiImageModel imageModel = new OpenAiImageModel(openAiImageApi, imageProperties.getOptions(), retryTemplate, (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((OpenAiImageModel)imageModel).setObservationConvention(arg_0));
        return imageModel;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.openai.audio.transcription", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public OpenAiAudioTranscriptionModel openAiAudioTranscriptionModel(OpenAiConnectionProperties commonProperties, OpenAiAudioTranscriptionProperties transcriptionProperties, RetryTemplate retryTemplate, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ObjectProvider<WebClient.Builder> webClientBuilderProvider, ResponseErrorHandler responseErrorHandler) {
        ResolvedConnectionProperties resolved = OpenAiAutoConfiguration.resolveConnectionProperties(commonProperties, transcriptionProperties, "transcription");
        OpenAiAudioApi openAiAudioApi = OpenAiAudioApi.builder().baseUrl(resolved.baseUrl()).apiKey((ApiKey)new SimpleApiKey(resolved.apiKey())).headers(resolved.headers()).restClientBuilder((RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder)).webClientBuilder((WebClient.Builder)webClientBuilderProvider.getIfAvailable(WebClient::builder)).responseErrorHandler(responseErrorHandler).build();
        return new OpenAiAudioTranscriptionModel(openAiAudioApi, transcriptionProperties.getOptions(), retryTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public OpenAiModerationModel openAiModerationClient(OpenAiConnectionProperties commonProperties, OpenAiModerationProperties moderationProperties, RetryTemplate retryTemplate, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ResponseErrorHandler responseErrorHandler) {
        ResolvedConnectionProperties resolved = OpenAiAutoConfiguration.resolveConnectionProperties(commonProperties, moderationProperties, "moderation");
        OpenAiModerationApi openAiModerationApi = OpenAiModerationApi.builder().baseUrl(resolved.baseUrl).apiKey((ApiKey)new SimpleApiKey(resolved.apiKey())).headers(resolved.headers()).restClientBuilder((RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder)).responseErrorHandler(responseErrorHandler).build();
        return new OpenAiModerationModel(openAiModerationApi, retryTemplate).withDefaultOptions(moderationProperties.getOptions());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.ai.openai.audio.speech", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public OpenAiAudioSpeechModel openAiAudioSpeechClient(OpenAiConnectionProperties commonProperties, OpenAiAudioSpeechProperties speechProperties, RetryTemplate retryTemplate, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ObjectProvider<WebClient.Builder> webClientBuilderProvider, ResponseErrorHandler responseErrorHandler) {
        ResolvedConnectionProperties resolved = OpenAiAutoConfiguration.resolveConnectionProperties(commonProperties, speechProperties, "speach");
        OpenAiAudioApi openAiAudioApi = OpenAiAudioApi.builder().baseUrl(resolved.baseUrl()).apiKey((ApiKey)new SimpleApiKey(resolved.apiKey())).headers(resolved.headers()).restClientBuilder((RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder)).webClientBuilder((WebClient.Builder)webClientBuilderProvider.getIfAvailable(WebClient::builder)).responseErrorHandler(responseErrorHandler).build();
        return new OpenAiAudioSpeechModel(openAiAudioApi, speechProperties.getOptions());
    }

    @Bean
    @ConditionalOnMissingBean
    public FunctionCallbackResolver springAiFunctionManager(ApplicationContext context) {
        DefaultFunctionCallbackResolver manager = new DefaultFunctionCallbackResolver();
        manager.setApplicationContext(context);
        return manager;
    }

    private record ResolvedConnectionProperties(String baseUrl, String apiKey, MultiValueMap<String, String> headers) {
    }
}

