/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml.stax;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.springframework.batch.item.xml.stax.AbstractEventWriterWrapper;
import org.springframework.util.StringUtils;

public class UnopenedElementClosingEventWriter
extends AbstractEventWriterWrapper {
    private final LinkedList<QName> unopenedElements;
    private final Writer ioWriter;

    public UnopenedElementClosingEventWriter(XMLEventWriter wrappedEventWriter, Writer ioWriter, List<QName> unopenedElements) {
        super(wrappedEventWriter);
        this.unopenedElements = new LinkedList<QName>(unopenedElements);
        this.ioWriter = ioWriter;
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        if (this.isUnopenedElementCloseEvent(event)) {
            QName element = this.unopenedElements.removeLast();
            String nsPrefix = !StringUtils.hasText((String)element.getPrefix()) ? "" : element.getPrefix() + ":";
            try {
                super.flush();
                this.ioWriter.write("</" + nsPrefix + element.getLocalPart() + ">");
                this.ioWriter.flush();
            }
            catch (IOException ioe) {
                throw new XMLStreamException("Unable to close tag: " + String.valueOf(element), ioe);
            }
        } else {
            super.add(event);
        }
    }

    private boolean isUnopenedElementCloseEvent(XMLEvent event) {
        if (this.unopenedElements.isEmpty()) {
            return false;
        }
        if (!event.isEndElement()) {
            return false;
        }
        return this.unopenedElements.getLast().equals(event.asEndElement().getName());
    }
}

