/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionAwareProxyFactory<T> {
    private final T target;
    private final boolean appendOnly;

    private TransactionAwareProxyFactory(T target) {
        this(target, false);
    }

    private TransactionAwareProxyFactory(T target, boolean appendOnly) {
        this.target = target;
        this.appendOnly = appendOnly;
    }

    protected final T begin(T target) {
        T t = target;
        synchronized (t) {
            if (target instanceof List) {
                if (this.appendOnly) {
                    return (T)new ArrayList();
                }
                return (T)new ArrayList((List)target);
            }
            if (target instanceof Set) {
                if (this.appendOnly) {
                    return (T)new HashSet();
                }
                return (T)new HashSet((Set)target);
            }
            if (target instanceof Map) {
                if (this.appendOnly) {
                    return (T)new HashMap();
                }
                return (T)new HashMap((Map)target);
            }
            throw new UnsupportedOperationException("Cannot copy target for this type: " + String.valueOf(target.getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit(T copy, T target) {
        T t = target;
        synchronized (t) {
            if (target instanceof Collection) {
                if (!this.appendOnly) {
                    ((Collection)target).clear();
                }
                ((Collection)target).addAll((Collection)copy);
            } else {
                if (!this.appendOnly) {
                    ((Map)target).clear();
                }
                ((Map)target).putAll((Map)copy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T createInstance() {
        T t = this.target;
        synchronized (t) {
            ProxyFactory factory = new ProxyFactory(this.target);
            factory.addAdvice((Advice)new TransactionAwareInterceptor());
            Object instance = factory.getProxy();
            return (T)instance;
        }
    }

    public static <K, V> Map<K, V> createTransactionalMap() {
        return new TransactionAwareProxyFactory(new ConcurrentHashMap()).createInstance();
    }

    public static <K, V> Map<K, V> createTransactionalMap(Map<K, V> map) {
        return new TransactionAwareProxyFactory<ConcurrentHashMap<K, V>>(new ConcurrentHashMap<K, V>(map)).createInstance();
    }

    public static <K, V> ConcurrentMap<K, V> createAppendOnlyTransactionalMap() {
        return new TransactionAwareProxyFactory(new ConcurrentHashMap(), true).createInstance();
    }

    public static <T> Set<T> createAppendOnlyTransactionalSet() {
        return new TransactionAwareProxyFactory(new CopyOnWriteArraySet(), true).createInstance();
    }

    public static <T> Set<T> createTransactionalSet() {
        return new TransactionAwareProxyFactory(new CopyOnWriteArraySet()).createInstance();
    }

    public static <T> Set<T> createTransactionalSet(Set<T> set) {
        return new TransactionAwareProxyFactory<CopyOnWriteArraySet<T>>(new CopyOnWriteArraySet<T>(set)).createInstance();
    }

    public static <T> List<T> createAppendOnlyTransactionalList() {
        return new TransactionAwareProxyFactory(new CopyOnWriteArrayList(), true).createInstance();
    }

    public static <T> List<T> createTransactionalList() {
        return new TransactionAwareProxyFactory(new CopyOnWriteArrayList()).createInstance();
    }

    public static <T> List<T> createTransactionalList(List<T> list) {
        return new TransactionAwareProxyFactory<CopyOnWriteArrayList<T>>(new CopyOnWriteArrayList<T>(list)).createInstance();
    }

    private class TransactionAwareInterceptor
    implements MethodInterceptor {
        private TransactionAwareInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Object cache;
            if (!TransactionSynchronizationManager.isActualTransactionActive()) {
                return invocation.proceed();
            }
            if (!TransactionSynchronizationManager.hasResource((Object)this)) {
                cache = TransactionAwareProxyFactory.this.begin(TransactionAwareProxyFactory.this.target);
                TransactionSynchronizationManager.bindResource((Object)this, (Object)cache);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TargetSynchronization(this, cache));
            } else {
                Object retrievedCache;
                cache = retrievedCache = TransactionSynchronizationManager.getResource((Object)this);
            }
            HashSet result = invocation.getMethod().invoke(cache, invocation.getArguments());
            if (TransactionAwareProxyFactory.this.appendOnly) {
                String methodName = invocation.getMethod().getName();
                if (result == null && methodName.equals("get") || Boolean.FALSE.equals(result) && methodName.startsWith("contains") || Boolean.TRUE.equals(result) && methodName.startsWith("isEmpty")) {
                    return invocation.proceed();
                }
                if (result instanceof Collection) {
                    HashSet set = new HashSet(result);
                    set.addAll((Collection)invocation.proceed());
                    result = set;
                }
            }
            return result;
        }
    }

    private class TargetSynchronization
    implements TransactionSynchronization {
        private final T cache;
        private final Object key;

        public TargetSynchronization(Object key, T cache) {
            this.cache = cache;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            if (status == 0) {
                Object t = TransactionAwareProxyFactory.this.target;
                synchronized (t) {
                    TransactionAwareProxyFactory.this.commit(this.cache, TransactionAwareProxyFactory.this.target);
                }
            }
            TransactionSynchronizationManager.unbindResource((Object)this.key);
        }
    }
}

