/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.web.jersey;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableServletEndpoint;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.annotation.ServletEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.jersey.JerseyEndpointResourceFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@ManagementContextConfiguration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={ResourceConfig.class})
@ConditionalOnBean(value={WebEndpointsSupplier.class})
@ConditionalOnMissingBean(type={"org.springframework.web.servlet.DispatcherServlet"})
class JerseyWebEndpointManagementContextConfiguration {
    JerseyWebEndpointManagementContextConfiguration() {
    }

    @Bean
    JerseyWebEndpointsResourcesRegistrar jerseyWebEndpointsResourcesRegistrar(Environment environment, ObjectProvider<ResourceConfig> resourceConfig, WebEndpointsSupplier webEndpointsSupplier, ServletEndpointsSupplier servletEndpointsSupplier, EndpointMediaTypes endpointMediaTypes, WebEndpointProperties webEndpointProperties) {
        String basePath = webEndpointProperties.getBasePath();
        boolean shouldRegisterLinks = this.shouldRegisterLinksMapping(environment, basePath);
        this.shouldRegisterLinksMapping(environment, basePath);
        return new JerseyWebEndpointsResourcesRegistrar((ResourceConfig)resourceConfig.getIfAvailable(), webEndpointsSupplier, servletEndpointsSupplier, endpointMediaTypes, basePath, shouldRegisterLinks);
    }

    private boolean shouldRegisterLinksMapping(Environment environment, String basePath) {
        return StringUtils.hasText((String)basePath) || ManagementPortType.get(environment).equals((Object)ManagementPortType.DIFFERENT);
    }

    static class JerseyWebEndpointsResourcesRegistrar {
        private final ResourceConfig resourceConfig;
        private final WebEndpointsSupplier webEndpointsSupplier;
        private final ServletEndpointsSupplier servletEndpointsSupplier;
        private final EndpointMediaTypes mediaTypes;
        private final String basePath;
        private final boolean shouldRegisterLinks;

        JerseyWebEndpointsResourcesRegistrar(ResourceConfig resourceConfig, WebEndpointsSupplier webEndpointsSupplier, ServletEndpointsSupplier servletEndpointsSupplier, EndpointMediaTypes endpointMediaTypes, String basePath, boolean shouldRegisterLinks) {
            this.resourceConfig = resourceConfig;
            this.webEndpointsSupplier = webEndpointsSupplier;
            this.servletEndpointsSupplier = servletEndpointsSupplier;
            this.mediaTypes = endpointMediaTypes;
            this.basePath = basePath;
            this.shouldRegisterLinks = shouldRegisterLinks;
        }

        @PostConstruct
        void register() {
            if (this.resourceConfig == null) {
                return;
            }
            Collection webEndpoints = this.webEndpointsSupplier.getEndpoints();
            Collection servletEndpoints = this.servletEndpointsSupplier.getEndpoints();
            EndpointLinksResolver linksResolver = this.getLinksResolver(webEndpoints, servletEndpoints);
            EndpointMapping mapping = new EndpointMapping(this.basePath);
            JerseyEndpointResourceFactory resourceFactory = new JerseyEndpointResourceFactory();
            this.register(resourceFactory.createEndpointResources(mapping, webEndpoints, this.mediaTypes, linksResolver, this.shouldRegisterLinks));
        }

        private EndpointLinksResolver getLinksResolver(Collection<ExposableWebEndpoint> webEndpoints, Collection<ExposableServletEndpoint> servletEndpoints) {
            ArrayList<Object> endpoints = new ArrayList<Object>(webEndpoints.size() + servletEndpoints.size());
            endpoints.addAll(webEndpoints);
            endpoints.addAll(servletEndpoints);
            return new EndpointLinksResolver(endpoints, this.basePath);
        }

        private void register(Collection<Resource> resources) {
            this.resourceConfig.registerResources(new HashSet<Resource>(resources));
        }
    }
}

