/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.orm.jpa;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jpa.HibernateMetrics;
import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, HibernateJpaAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={EntityManagerFactory.class, SessionFactory.class, MeterRegistry.class})
@ConditionalOnBean(value={EntityManagerFactory.class, MeterRegistry.class})
public class HibernateMetricsAutoConfiguration {
    private static final String ENTITY_MANAGER_FACTORY_SUFFIX = "entityManagerFactory";

    @Autowired
    public void bindEntityManagerFactoriesToRegistry(Map<String, EntityManagerFactory> entityManagerFactories, MeterRegistry registry) {
        entityManagerFactories.forEach((name, factory) -> this.bindEntityManagerFactoryToRegistry((String)name, (EntityManagerFactory)factory, registry));
    }

    private void bindEntityManagerFactoryToRegistry(String beanName, EntityManagerFactory entityManagerFactory, MeterRegistry registry) {
        String entityManagerFactoryName = this.getEntityManagerFactoryName(beanName);
        try {
            new HibernateMetrics((SessionFactory)entityManagerFactory.unwrap(SessionFactory.class), entityManagerFactoryName, Collections.emptyList()).bindTo(registry);
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
    }

    private String getEntityManagerFactoryName(String beanName) {
        if (beanName.length() > ENTITY_MANAGER_FACTORY_SUFFIX.length() && StringUtils.endsWithIgnoreCase((String)beanName, (String)ENTITY_MANAGER_FACTORY_SUFFIX)) {
            return beanName.substring(0, beanName.length() - ENTITY_MANAGER_FACTORY_SUFFIX.length());
        }
        return beanName;
    }
}

