/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.endpoint.mvc.AbstractMvcEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.logging.LogFile;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

@ConfigurationProperties(prefix="endpoints.logfile")
public class LogFileMvcEndpoint
extends AbstractMvcEndpoint {
    private static final Log logger = LogFactory.getLog(LogFileMvcEndpoint.class);
    private File externalFile;

    public LogFileMvcEndpoint() {
        super("/logfile", true);
    }

    public File getExternalFile() {
        return this.externalFile;
    }

    public void setExternalFile(File externalFile) {
        this.externalFile = externalFile;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.HEAD})
    public void invoke(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.isEnabled()) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return;
        }
        Resource resource = this.getLogFileResource();
        if (resource != null && !resource.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Log file '" + resource + "' does not exist"));
            }
            resource = null;
        }
        Handler handler = new Handler(resource, request.getServletContext());
        handler.handleRequest(request, response);
    }

    private Resource getLogFileResource() {
        if (this.externalFile != null) {
            return new FileSystemResource(this.externalFile);
        }
        LogFile logFile = LogFile.get((PropertyResolver)this.getEnvironment());
        if (logFile == null) {
            logger.debug((Object)"Missing 'logging.file' or 'logging.path' properties");
            return null;
        }
        return new FileSystemResource(logFile.toString());
    }

    private static class Handler
    extends ResourceHttpRequestHandler {
        private final Resource resource;

        Handler(Resource resource, ServletContext servletContext) {
            this.resource = resource;
            this.getLocations().add(resource);
            try {
                this.setServletContext(servletContext);
                this.afterPropertiesSet();
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        protected void initAllowedLocations() {
            this.getLocations().clear();
        }

        protected Resource getResource(HttpServletRequest request) throws IOException {
            return this.resource;
        }

        protected MediaType getMediaType(Resource resource) {
            return MediaType.TEXT_PLAIN;
        }
    }
}

