/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import java.util.function.Function;
import org.springframework.boot.buildpack.platform.docker.type.RandomString;
import org.springframework.util.Assert;

public final class VolumeName {
    private final String value;

    private VolumeName(String value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value.equals(((VolumeName)obj).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    public static VolumeName random(String prefix) {
        return VolumeName.random(prefix, 10);
    }

    public static VolumeName random(String prefix, int randomLength) {
        return VolumeName.of(RandomString.generate(prefix, randomLength));
    }

    public static <S> VolumeName basedOn(S source, String prefix, String suffix, int digestLength) {
        return VolumeName.basedOn(source, Object::toString, prefix, suffix, digestLength);
    }

    public static <S> VolumeName basedOn(S source, Function<S, String> nameExtractor, String prefix, String suffix, int digestLength) {
        Assert.notNull(source, (String)"Source must not be null");
        Assert.notNull(nameExtractor, (String)"NameExtractor must not be null");
        Assert.notNull((Object)prefix, (String)"Prefix must not be null");
        Assert.notNull((Object)suffix, (String)"Suffix must not be null");
        return VolumeName.of(prefix + VolumeName.getDigest(nameExtractor.apply(source), digestLength) + suffix);
    }

    private static String getDigest(String name, int length) {
        try {
            MessageDigest digest = MessageDigest.getInstance("sha-256");
            return VolumeName.asHexString(digest.digest(name.getBytes(StandardCharsets.UTF_8)), length);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static String asHexString(byte[] digest, int digestLength) {
        Assert.isTrue((digestLength <= digest.length ? 1 : 0) != 0, () -> "DigestLength must be less than or equal to " + digest.length);
        return HexFormat.of().formatHex(digest, 0, digestLength);
    }

    public static VolumeName of(String value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        return new VolumeName(value);
    }
}

