/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.springframework.boot.buildpack.platform.io.IOSupplier;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public interface Content {
    public int size();

    public void writeTo(OutputStream var1) throws IOException;

    public static Content of(String string) {
        Assert.notNull((Object)string, (String)"String must not be null");
        return Content.of(string.getBytes(StandardCharsets.UTF_8));
    }

    public static Content of(byte[] bytes) {
        Assert.notNull((Object)bytes, (String)"Bytes must not be null");
        return Content.of(bytes.length, () -> new ByteArrayInputStream(bytes));
    }

    public static Content of(File file) {
        Assert.notNull((Object)file, (String)"File must not be null");
        return Content.of((int)file.length(), () -> new FileInputStream(file));
    }

    public static Content of(final int size, final IOSupplier<InputStream> supplier) {
        Assert.isTrue((size >= 0 ? 1 : 0) != 0, (String)"Size must not be negative");
        Assert.notNull(supplier, (String)"Supplier must not be null");
        return new Content(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public void writeTo(OutputStream outputStream) throws IOException {
                FileCopyUtils.copy((InputStream)((InputStream)supplier.get()), (OutputStream)outputStream);
            }
        };
    }
}

