/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import org.springframework.boot.loader.tools.InputStreamSupplier;

final class Digest {
    private Digest() {
    }

    static String sha1(InputStreamSupplier supplier) throws IOException {
        String string;
        DigestInputStream inputStream = new DigestInputStream(supplier.openStream(), MessageDigest.getInstance("SHA-1"));
        try {
            inputStream.readAllBytes();
            string = HexFormat.of().formatHex(inputStream.getMessageDigest().digest());
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IllegalStateException(ex);
            }
        }
        inputStream.close();
        return string;
    }
}

