/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.config.RandomValuePropertySource;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.env.EnumerableCompositePropertySource;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.PropertySourcesLoader;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;

public class ConfigFileApplicationListener
implements EnvironmentPostProcessor,
ApplicationListener<ApplicationEvent>,
Ordered {
    private static final String DEFAULT_PROPERTIES = "defaultProperties";
    private static final String DEFAULT_SEARCH_LOCATIONS = "classpath:/,classpath:/config/,file:./,file:./config/";
    private static final String DEFAULT_NAMES = "application";
    public static final String ACTIVE_PROFILES_PROPERTY = "spring.profiles.active";
    public static final String INCLUDE_PROFILES_PROPERTY = "spring.profiles.include";
    public static final String CONFIG_NAME_PROPERTY = "spring.config.name";
    public static final String CONFIG_LOCATION_PROPERTY = "spring.config.location";
    public static final int DEFAULT_ORDER = -2147483638;
    public static final String APPLICATION_CONFIGURATION_PROPERTY_SOURCE_NAME = "applicationConfigurationProperties";
    private final DeferredLog logger = new DeferredLog();
    private String searchLocations;
    private String names;
    private int order = -2147483638;
    private final ConversionService conversionService = new DefaultConversionService();

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            this.onApplicationEnvironmentPreparedEvent((ApplicationEnvironmentPreparedEvent)event);
        }
        if (event instanceof ApplicationPreparedEvent) {
            this.onApplicationPreparedEvent(event);
        }
    }

    private void onApplicationEnvironmentPreparedEvent(ApplicationEnvironmentPreparedEvent event) {
        List<EnvironmentPostProcessor> postProcessors = this.loadPostProcessors();
        postProcessors.add(this);
        AnnotationAwareOrderComparator.sort(postProcessors);
        for (EnvironmentPostProcessor postProcessor : postProcessors) {
            postProcessor.postProcessEnvironment(event.getEnvironment(), event.getSpringApplication());
        }
    }

    List<EnvironmentPostProcessor> loadPostProcessors() {
        return SpringFactoriesLoader.loadFactories(EnvironmentPostProcessor.class, (ClassLoader)this.getClass().getClassLoader());
    }

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.addPropertySources(environment, application.getResourceLoader());
        this.configureIgnoreBeanInfo(environment);
        this.bindToSpringApplication(environment, application);
    }

    private void configureIgnoreBeanInfo(ConfigurableEnvironment environment) {
        if (System.getProperty("spring.beaninfo.ignore") == null) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.beaninfo.");
            Boolean ignore = resolver.getProperty("ignore", Boolean.class, Boolean.TRUE);
            System.setProperty("spring.beaninfo.ignore", ignore.toString());
        }
    }

    private void onApplicationPreparedEvent(ApplicationEvent event) {
        this.logger.replayTo(ConfigFileApplicationListener.class);
        this.addPostProcessors(((ApplicationPreparedEvent)event).getApplicationContext());
    }

    protected void addPropertySources(ConfigurableEnvironment environment, ResourceLoader resourceLoader) {
        RandomValuePropertySource.addToEnvironment(environment);
        try {
            new Loader(environment, resourceLoader).load();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load configuration files", ex);
        }
    }

    protected void bindToSpringApplication(ConfigurableEnvironment environment, SpringApplication application) {
        PropertiesConfigurationFactory<SpringApplication> binder = new PropertiesConfigurationFactory<SpringApplication>(application);
        binder.setTargetName("spring.main");
        binder.setConversionService(this.conversionService);
        binder.setPropertySources((PropertySources)environment.getPropertySources());
        try {
            binder.bindPropertiesToTarget();
        }
        catch (BindException ex) {
            throw new IllegalStateException("Cannot bind to SpringApplication", ex);
        }
    }

    protected void addPostProcessors(ConfigurableApplicationContext context) {
        context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new PropertySourceOrderingPostProcessor(context));
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setSearchLocations(String locations) {
        Assert.hasLength((String)locations, (String)"Locations must not be empty");
        this.searchLocations = locations;
    }

    public void setSearchNames(String names) {
        Assert.hasLength((String)names, (String)"Names must not be empty");
        this.names = names;
    }

    static class ConfigurationPropertySources
    extends EnumerablePropertySource<Collection<PropertySource<?>>> {
        private final Collection<PropertySource<?>> sources;
        private final String[] names;

        ConfigurationPropertySources(Collection<PropertySource<?>> sources) {
            super(ConfigFileApplicationListener.APPLICATION_CONFIGURATION_PROPERTY_SOURCE_NAME, sources);
            this.sources = sources;
            ArrayList<String> names = new ArrayList<String>();
            for (PropertySource<?> source : sources) {
                if (!(source instanceof EnumerablePropertySource)) continue;
                names.addAll(Arrays.asList(((EnumerablePropertySource)source).getPropertyNames()));
            }
            this.names = names.toArray(new String[names.size()]);
        }

        public Object getProperty(String name) {
            for (PropertySource<?> propertySource : this.sources) {
                Object value = propertySource.getProperty(name);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        public static void finishAndRelocate(MutablePropertySources propertySources) {
            String name = ConfigFileApplicationListener.APPLICATION_CONFIGURATION_PROPERTY_SOURCE_NAME;
            ConfigurationPropertySources removed = (ConfigurationPropertySources)propertySources.get(name);
            if (removed != null) {
                for (PropertySource<?> propertySource : removed.sources) {
                    if (propertySource instanceof EnumerableCompositePropertySource) {
                        EnumerableCompositePropertySource composite = (EnumerableCompositePropertySource)propertySource;
                        for (PropertySource nested : (Collection)composite.getSource()) {
                            propertySources.addAfter(name, nested);
                            name = nested.getName();
                        }
                        continue;
                    }
                    propertySources.addAfter(name, propertySource);
                }
                propertySources.remove(ConfigFileApplicationListener.APPLICATION_CONFIGURATION_PROPERTY_SOURCE_NAME);
            }
        }

        public String[] getPropertyNames() {
            return this.names;
        }
    }

    private static class Profile {
        private final String name;
        private final boolean defaultProfile;

        Profile(String name) {
            this(name, false);
        }

        Profile(String name, boolean defaultProfile) {
            Assert.notNull((Object)name, (String)"Name must not be null");
            this.name = name;
            this.defaultProfile = defaultProfile;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDefaultProfile() {
            return this.defaultProfile;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return ((Profile)obj).name.equals(this.name);
        }
    }

    private class Loader {
        private final Log logger;
        private final ConfigurableEnvironment environment;
        private final ResourceLoader resourceLoader;
        private PropertySourcesLoader propertiesLoader;
        private Queue<Profile> profiles;
        private List<Profile> processedProfiles;
        private boolean activatedProfiles;

        Loader(ConfigurableEnvironment environment, ResourceLoader resourceLoader) {
            this.logger = ConfigFileApplicationListener.this.logger;
            this.environment = environment;
            this.resourceLoader = resourceLoader == null ? new DefaultResourceLoader() : resourceLoader;
        }

        public void load() throws IOException {
            this.propertiesLoader = new PropertySourcesLoader();
            this.activatedProfiles = false;
            this.profiles = Collections.asLifoQueue(new LinkedList());
            this.processedProfiles = new LinkedList<Profile>();
            Set<Profile> initialActiveProfiles = this.initializeActiveProfiles();
            this.profiles.addAll(this.getUnprocessedActiveProfiles(initialActiveProfiles));
            if (this.profiles.isEmpty()) {
                for (String defaultProfileName : this.environment.getDefaultProfiles()) {
                    Profile defaultProfile = new Profile(defaultProfileName, true);
                    if (this.profiles.contains(defaultProfile)) continue;
                    this.profiles.add(defaultProfile);
                }
            }
            this.profiles.add(null);
            while (!this.profiles.isEmpty()) {
                Profile profile = this.profiles.poll();
                for (String location : this.getSearchLocations()) {
                    if (!location.endsWith("/")) {
                        this.load(location, null, profile);
                        continue;
                    }
                    for (String name : this.getSearchNames()) {
                        this.load(location, name, profile);
                    }
                }
                this.processedProfiles.add(profile);
            }
            this.addConfigurationProperties(this.propertiesLoader.getPropertySources());
        }

        private Set<Profile> initializeActiveProfiles() {
            if (!this.environment.containsProperty(ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY)) {
                return Collections.emptySet();
            }
            Set<Profile> activeProfiles = this.getProfilesForValue(this.environment.getProperty(ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY));
            this.maybeActivateProfiles(activeProfiles);
            return activeProfiles;
        }

        private List<Profile> getUnprocessedActiveProfiles(Set<Profile> initialActiveProfiles) {
            ArrayList<Profile> unprocessedActiveProfiles = new ArrayList<Profile>();
            for (String profileName : this.environment.getActiveProfiles()) {
                Profile profile = new Profile(profileName);
                if (initialActiveProfiles.contains(profile)) continue;
                unprocessedActiveProfiles.add(profile);
            }
            Collections.reverse(unprocessedActiveProfiles);
            return unprocessedActiveProfiles;
        }

        private void load(String location, String name, Profile profile) throws IOException {
            String group = "profile=" + (profile == null ? "" : profile);
            if (!StringUtils.hasText((String)name)) {
                this.loadIntoGroup(group, location, profile);
            } else {
                for (String ext : this.propertiesLoader.getAllFileExtensions()) {
                    if (profile != null) {
                        this.loadIntoGroup(group, location + name + "-" + profile + "." + ext, null);
                        for (Profile processedProfile : this.processedProfiles) {
                            if (processedProfile == null) continue;
                            this.loadIntoGroup(group, location + name + "-" + processedProfile + "." + ext, profile);
                        }
                        this.loadIntoGroup(group, location + name + "-" + profile + "." + ext, profile);
                    }
                    this.loadIntoGroup(group, location + name + "." + ext, profile);
                }
            }
        }

        private PropertySource<?> loadIntoGroup(String identifier, String location, Profile profile) throws IOException {
            Resource resource = this.resourceLoader.getResource(location);
            PropertySource<?> propertySource = null;
            StringBuilder msg = new StringBuilder();
            if (resource != null && resource.exists()) {
                String name = "applicationConfig: [" + location + "]";
                String group = "applicationConfig: [" + identifier + "]";
                propertySource = this.propertiesLoader.load(resource, group, name, profile == null ? null : profile.getName());
                if (propertySource != null) {
                    msg.append("Loaded ");
                    this.handleProfileProperties(propertySource);
                } else {
                    msg.append("Skipped (empty) ");
                }
            } else {
                msg.append("Skipped ");
            }
            msg.append("config file ");
            msg.append(this.getResourceDescription(location, resource));
            if (profile != null) {
                msg.append(" for profile ").append(profile);
            }
            if (resource == null || !resource.exists()) {
                msg.append(" resource not found");
                this.logger.trace((Object)msg);
            } else {
                this.logger.debug((Object)msg);
            }
            return propertySource;
        }

        private String getResourceDescription(String location, Resource resource) {
            String resourceDescription = "'" + location + "'";
            if (resource != null) {
                try {
                    resourceDescription = String.format("'%s' (%s)", resource.getURI().toASCIIString(), location);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return resourceDescription;
        }

        private void handleProfileProperties(PropertySource<?> propertySource) {
            Set<Profile> activeProfiles = this.getProfilesForValue(propertySource.getProperty(ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY));
            this.maybeActivateProfiles(activeProfiles);
            Set<Profile> includeProfiles = this.getProfilesForValue(propertySource.getProperty(ConfigFileApplicationListener.INCLUDE_PROFILES_PROPERTY));
            this.addProfiles(includeProfiles);
        }

        private void maybeActivateProfiles(Set<Profile> profiles) {
            if (this.activatedProfiles) {
                if (!profiles.isEmpty()) {
                    this.logger.debug((Object)("Profiles already activated, '" + profiles + "' will not be applied"));
                }
                return;
            }
            if (!profiles.isEmpty()) {
                this.addProfiles(profiles);
                this.logger.debug((Object)("Activated profiles " + StringUtils.collectionToCommaDelimitedString(profiles)));
                this.activatedProfiles = true;
                this.removeUnprocessedDefaultProfiles();
            }
        }

        private void removeUnprocessedDefaultProfiles() {
            Iterator iterator = this.profiles.iterator();
            while (iterator.hasNext()) {
                if (!((Profile)iterator.next()).isDefaultProfile()) continue;
                iterator.remove();
            }
        }

        private Set<Profile> getProfilesForValue(Object property) {
            String value = property == null ? null : property.toString();
            Set<String> profileNames = this.asResolvedSet(value, null);
            LinkedHashSet<Profile> profiles = new LinkedHashSet<Profile>();
            for (String profileName : profileNames) {
                profiles.add(new Profile(profileName));
            }
            return profiles;
        }

        private void addProfiles(Set<Profile> profiles) {
            for (Profile profile : profiles) {
                this.profiles.add(profile);
                if (this.environment.acceptsProfiles(new String[]{profile.getName()})) continue;
                this.prependProfile(this.environment, profile);
            }
        }

        private void prependProfile(ConfigurableEnvironment environment, Profile profile) {
            LinkedHashSet<String> profiles = new LinkedHashSet<String>();
            environment.getActiveProfiles();
            profiles.add(profile.getName());
            profiles.addAll(Arrays.asList(environment.getActiveProfiles()));
            environment.setActiveProfiles(profiles.toArray(new String[profiles.size()]));
        }

        private Set<String> getSearchLocations() {
            LinkedHashSet<String> locations = new LinkedHashSet<String>();
            if (this.environment.containsProperty(ConfigFileApplicationListener.CONFIG_LOCATION_PROPERTY)) {
                for (String path : this.asResolvedSet(this.environment.getProperty(ConfigFileApplicationListener.CONFIG_LOCATION_PROPERTY), null)) {
                    if (!path.contains("$") && !ResourceUtils.isUrl((String)(path = StringUtils.cleanPath((String)path)))) {
                        path = "file:" + path;
                    }
                    locations.add(path);
                }
            }
            locations.addAll(this.asResolvedSet(ConfigFileApplicationListener.this.searchLocations, ConfigFileApplicationListener.DEFAULT_SEARCH_LOCATIONS));
            return locations;
        }

        private Set<String> getSearchNames() {
            if (this.environment.containsProperty(ConfigFileApplicationListener.CONFIG_NAME_PROPERTY)) {
                return this.asResolvedSet(this.environment.getProperty(ConfigFileApplicationListener.CONFIG_NAME_PROPERTY), null);
            }
            return this.asResolvedSet(ConfigFileApplicationListener.this.names, ConfigFileApplicationListener.DEFAULT_NAMES);
        }

        private Set<String> asResolvedSet(String value, String fallback) {
            List<String> list = Arrays.asList(StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)(value != null ? this.environment.resolvePlaceholders(value) : fallback))));
            Collections.reverse(list);
            return new LinkedHashSet<String>(list);
        }

        private void addConfigurationProperties(MutablePropertySources sources) {
            ArrayList reorderedSources = new ArrayList();
            for (PropertySource item : sources) {
                reorderedSources.add(item);
            }
            this.addConfigurationProperties(new ConfigurationPropertySources(reorderedSources));
        }

        private void addConfigurationProperties(ConfigurationPropertySources configurationSources) {
            MutablePropertySources existingSources = this.environment.getPropertySources();
            if (existingSources.contains(ConfigFileApplicationListener.DEFAULT_PROPERTIES)) {
                existingSources.addBefore(ConfigFileApplicationListener.DEFAULT_PROPERTIES, (PropertySource)configurationSources);
            } else {
                existingSources.addLast((PropertySource)configurationSources);
            }
        }
    }

    private class PropertySourceOrderingPostProcessor
    implements BeanFactoryPostProcessor,
    Ordered {
        private ConfigurableApplicationContext context;

        PropertySourceOrderingPostProcessor(ConfigurableApplicationContext context) {
            this.context = context;
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            this.reorderSources(this.context.getEnvironment());
        }

        private void reorderSources(ConfigurableEnvironment environment) {
            ConfigurationPropertySources.finishAndRelocate(environment.getPropertySources());
            PropertySource defaultProperties = environment.getPropertySources().remove(ConfigFileApplicationListener.DEFAULT_PROPERTIES);
            if (defaultProperties != null) {
                environment.getPropertySources().addLast(defaultProperties);
            }
        }
    }
}

