/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.SimpleStatement;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.repository.query.AbstractCassandraQuery;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.ExpressionEvaluatingParameterBinder;
import org.springframework.data.cassandra.repository.query.StringBasedQuery;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class StringBasedCassandraQuery
extends AbstractCassandraQuery {
    private final StringBasedQuery stringBasedQuery;

    public StringBasedCassandraQuery(CassandraQueryMethod queryMethod, CassandraOperations operations, SpelExpressionParser expressionParser, EvaluationContextProvider evaluationContextProvider) {
        this(queryMethod.getRequiredAnnotatedQuery(), queryMethod, operations, expressionParser, evaluationContextProvider);
    }

    public StringBasedCassandraQuery(String query, CassandraQueryMethod queryMethod, CassandraOperations operations, SpelExpressionParser expressionParser, EvaluationContextProvider evaluationContextProvider) {
        super(queryMethod, operations);
        this.stringBasedQuery = new StringBasedQuery(query, new ExpressionEvaluatingParameterBinder(expressionParser, evaluationContextProvider));
    }

    protected StringBasedQuery getStringBasedQuery() {
        return this.stringBasedQuery;
    }

    public SimpleStatement createQuery(CassandraParameterAccessor parameterAccessor) {
        return this.getQueryStatementCreator().select(this.getStringBasedQuery(), parameterAccessor);
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }
}

