/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.lang.Nullable;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;

public class OxmSerializer
implements InitializingBean,
RedisSerializer<Object> {
    @Nullable
    private Marshaller marshaller;
    @Nullable
    private Unmarshaller unmarshaller;

    public OxmSerializer() {
    }

    public OxmSerializer(Marshaller marshaller, Unmarshaller unmarshaller) {
        this.setMarshaller(marshaller);
        this.setUnmarshaller(unmarshaller);
    }

    public void setMarshaller(Marshaller marshaller) {
        Assert.notNull((Object)marshaller, (String)"Marshaller must not be null!");
        this.marshaller = marshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        Assert.notNull((Object)unmarshaller, (String)"Unmarshaller must not be null!");
        this.unmarshaller = unmarshaller;
    }

    public void afterPropertiesSet() {
        Assert.state((this.marshaller != null ? 1 : 0) != 0, (String)"non-null marshaller required");
        Assert.state((this.unmarshaller != null ? 1 : 0) != 0, (String)"non-null unmarshaller required");
    }

    @Override
    public Object deserialize(@Nullable byte[] bytes) throws SerializationException {
        if (SerializationUtils.isEmpty(bytes)) {
            return null;
        }
        try {
            return this.unmarshaller.unmarshal((Source)new StreamSource(new ByteArrayInputStream(bytes)));
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot deserialize bytes", ex);
        }
    }

    @Override
    public byte[] serialize(@Nullable Object t) throws SerializationException {
        if (t == null) {
            return SerializationUtils.EMPTY_ARRAY;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(stream);
        try {
            this.marshaller.marshal(t, (Result)result);
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot serialize object", ex);
        }
        return stream.toByteArray();
    }
}

