/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.collections;

import java.util.function.Supplier;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.support.collections.DefaultRedisMap;
import org.springframework.data.redis.support.collections.DefaultRedisSet;
import org.springframework.data.redis.support.collections.RedisList;
import org.springframework.data.redis.support.collections.RedisProperties;
import org.springframework.data.redis.support.collections.RedisStore;
import org.springframework.data.redis.support.collections.RedisZSet;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RedisCollectionFactoryBean
implements SmartFactoryBean<RedisStore>,
BeanNameAware,
InitializingBean {
    @Nullable
    private CollectionType type;
    @Nullable
    private RedisTemplate<String, ?> template;
    @Nullable
    private String key;
    @Nullable
    private String beanName;
    @Nullable
    private Lazy<RedisStore> store;

    public void afterPropertiesSet() {
        if (!StringUtils.hasText((String)this.key)) {
            this.key = this.beanName;
        }
        Assert.hasText((String)this.key, (String)"Collection key is required - no key or bean name specified");
        Assert.notNull(this.template, (String)"Redis template is required");
        this.store = Lazy.of(() -> {
            DataType keyType = this.template.type(this.key);
            Assert.isTrue((!DataType.STREAM.equals((Object)keyType) ? 1 : 0) != 0, (String)"Cannot create store on keys of type 'STREAM'");
            if (this.type == null) {
                this.type = CollectionType.findCollectionType(keyType, () -> CollectionType.LIST);
            }
            if (keyType != null && DataType.NONE != keyType && this.type.dataType() != keyType) {
                throw new IllegalArgumentException("Cannot create collection type '%s' for a key containing '%s'".formatted(new Object[]{this.type, keyType}));
            }
            return this.createStore(this.type, this.key, this.template);
        });
    }

    private RedisStore createStore(CollectionType collectionType, String key, RedisOperations<String, ?> operations) {
        return switch (collectionType) {
            default -> throw new IncompatibleClassChangeError();
            case CollectionType.LIST -> RedisList.create(key, operations);
            case CollectionType.SET -> new DefaultRedisSet(key, operations);
            case CollectionType.ZSET -> RedisZSet.create(key, operations);
            case CollectionType.PROPERTIES -> new RedisProperties(key, operations);
            case CollectionType.MAP -> new DefaultRedisMap(key, operations);
        };
    }

    public RedisStore getObject() {
        Assert.state((this.store != null ? 1 : 0) != 0, (String)"RedisCollectionFactoryBean is not initialized. Ensure to initialize this factory by calling afterPropertiesSet() before obtaining the factory object.");
        return (RedisStore)this.store.get();
    }

    public Class<?> getObjectType() {
        return this.store != null ? ((RedisStore)this.store.get()).getClass() : RedisStore.class;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setType(CollectionType type) {
        this.type = type;
    }

    public void setTemplate(RedisTemplate<String, ?> template) {
        this.template = template;
    }

    public void setKey(String key) {
        this.key = key;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CollectionType {
        LIST{

            @Override
            public DataType dataType() {
                return DataType.LIST;
            }
        }
        ,
        SET{

            @Override
            public DataType dataType() {
                return DataType.SET;
            }
        }
        ,
        ZSET{

            @Override
            public DataType dataType() {
                return DataType.ZSET;
            }
        }
        ,
        MAP{

            @Override
            public DataType dataType() {
                return DataType.HASH;
            }
        }
        ,
        PROPERTIES{

            @Override
            public DataType dataType() {
                return DataType.HASH;
            }
        };


        abstract DataType dataType();

        static CollectionType findCollectionType(@Nullable DataType dataType, Supplier<CollectionType> ifNotFound) {
            if (dataType == null) {
                return ifNotFound.get();
            }
            for (CollectionType collectionType : CollectionType.values()) {
                if (collectionType.dataType() != dataType) continue;
                return collectionType;
            }
            return ifNotFound.get();
        }
    }
}

