/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo.config.annotation.web.reactive;

import java.time.Duration;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.session.config.annotation.web.server.SpringWebSessionConfiguration;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.JdkMongoSessionConverter;
import org.springframework.session.data.mongo.ReactiveMongoOperationsSessionRepository;
import org.springframework.session.data.mongo.config.annotation.web.reactive.EnableMongoWebSession;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Configuration
public class ReactiveMongoWebSessionConfiguration
extends SpringWebSessionConfiguration
implements BeanClassLoaderAware,
EmbeddedValueResolverAware,
ImportAware {
    private AbstractMongoSessionConverter mongoSessionConverter;
    private Integer maxInactiveIntervalInSeconds;
    private String collectionName;
    private StringValueResolver embeddedValueResolver;
    @Autowired(required=false)
    private MongoOperations mongoOperations;
    private ClassLoader classLoader;

    @Bean
    public ReactiveMongoOperationsSessionRepository reactiveMongoOperationsSessionRepository(ReactiveMongoOperations operations) {
        ReactiveMongoOperationsSessionRepository repository = new ReactiveMongoOperationsSessionRepository(operations);
        if (this.mongoSessionConverter != null) {
            repository.setMongoSessionConverter(this.mongoSessionConverter);
        } else {
            JdkMongoSessionConverter mongoSessionConverter = new JdkMongoSessionConverter((Converter<Object, byte[]>)new SerializingConverter(), (Converter<byte[], Object>)new DeserializingConverter(this.classLoader), Duration.ofSeconds(1800L));
            repository.setMongoSessionConverter(mongoSessionConverter);
        }
        if (this.maxInactiveIntervalInSeconds != null) {
            repository.setMaxInactiveIntervalInSeconds(this.maxInactiveIntervalInSeconds);
        }
        if (this.collectionName != null) {
            repository.setCollectionName(this.collectionName);
        }
        if (this.mongoOperations != null) {
            repository.setBlockingMongoOperations(this.mongoOperations);
        }
        return repository;
    }

    @Autowired(required=false)
    public void setMongoSessionConverter(AbstractMongoSessionConverter mongoSessionConverter) {
        this.mongoSessionConverter = mongoSessionConverter;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableMongoWebSession.class.getName()));
        this.maxInactiveIntervalInSeconds = (Integer)attributes.getNumber("maxInactiveIntervalInSeconds");
        String collectionNameValue = attributes.getString("collectionName");
        if (StringUtils.hasText((String)collectionNameValue)) {
            this.collectionName = this.embeddedValueResolver.resolveStringValue(collectionNameValue);
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEmbeddedValueResolver(StringValueResolver embeddedValueResolver) {
        this.embeddedValueResolver = embeddedValueResolver;
    }

    public Integer getMaxInactiveIntervalInSeconds() {
        return this.maxInactiveIntervalInSeconds;
    }

    public void setMaxInactiveIntervalInSeconds(Integer maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }
}

