/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.hazelcast;

import com.hazelcast.map.AbstractEntryProcessor;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.springframework.session.MapSession;

public class SessionUpdateEntryProcessor
extends AbstractEntryProcessor<String, MapSession> {
    private Instant lastAccessedTime;
    private Duration maxInactiveInterval;
    private Map<String, Object> delta;

    public Object process(Map.Entry<String, MapSession> entry) {
        MapSession value = entry.getValue();
        if (value == null) {
            return Boolean.FALSE;
        }
        if (this.lastAccessedTime != null) {
            value.setLastAccessedTime(this.lastAccessedTime);
        }
        if (this.maxInactiveInterval != null) {
            value.setMaxInactiveInterval(this.maxInactiveInterval);
        }
        if (this.delta != null) {
            for (Map.Entry<String, Object> attribute : this.delta.entrySet()) {
                if (attribute.getValue() != null) {
                    value.setAttribute(attribute.getKey(), attribute.getValue());
                    continue;
                }
                value.removeAttribute(attribute.getKey());
            }
        }
        entry.setValue(value);
        return Boolean.TRUE;
    }

    void setLastAccessedTime(Instant lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    void setMaxInactiveInterval(Duration maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    void setDelta(Map<String, Object> delta) {
        this.delta = delta;
    }
}

