/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class HostnameTask
extends Task {
    private String property = "hostname";
    private boolean useIp = false;
    private String host = null;
    private String nIC = null;
    private boolean failOnError = false;
    private boolean showAll = false;

    public void setProperty(String p) {
        this.property = p;
    }

    public void setShowip(boolean b) {
        this.useIp = b;
    }

    public void setFailonerror(boolean b) {
        this.failOnError = b;
    }

    public void setNic(String n) {
        this.nIC = n;
    }

    public void setShowall(boolean b) {
        this.showAll = b;
    }

    public void execute() {
        try {
            if (this.showAll) {
                StringBuffer hostnames = new StringBuffer();
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                while (nics.hasMoreElements()) {
                    NetworkInterface nic = nics.nextElement();
                    hostnames.append(nic.getName() + ":");
                    Enumeration<InetAddress> addrs = nic.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        String hostname;
                        InetAddress addr = addrs.nextElement();
                        String string = hostname = this.useIp ? addr.getHostAddress() : addr.getHostName();
                        if (hostname != null && hostname.trim().length() > 0) {
                            hostnames.append(hostname);
                        }
                        if (!addrs.hasMoreElements()) continue;
                        hostnames.append(", ");
                    }
                    if (!nics.hasMoreElements()) continue;
                    hostnames.append(", ");
                }
                this.getProject().setProperty(this.property, hostnames.toString());
            } else if (this.nIC != null) {
                StringBuffer hostnames = new StringBuffer();
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                while (nics.hasMoreElements()) {
                    NetworkInterface nic = nics.nextElement();
                    if (!this.nIC.equals(nic.getName())) continue;
                    hostnames.append(nic.getName() + ":");
                    Enumeration<InetAddress> addrs = nic.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        String hostname;
                        InetAddress addr = addrs.nextElement();
                        String string = hostname = this.useIp ? addr.getHostAddress() : addr.getHostName();
                        if (hostname != null && hostname.trim().length() > 0) {
                            hostnames.append(hostname);
                        }
                        if (!addrs.hasMoreElements()) continue;
                        hostnames.append(", ");
                    }
                }
                this.getProject().setProperty(this.property, hostnames.toString());
            } else {
                InetAddress addr = InetAddress.getLocalHost();
                String hostname = this.useIp ? addr.getHostAddress() : addr.getHostName();
                this.getProject().setProperty(this.property, hostname);
            }
        }
        catch (IOException e) {
            if (this.failOnError) {
                throw new BuildException(e.getMessage());
            }
            this.log(e.getMessage());
        }
    }
}

