/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.core.engine.velocity;

import cn.smallbun.screw.core.engine.AbstractTemplateEngine;
import cn.smallbun.screw.core.engine.EngineConfig;
import cn.smallbun.screw.core.engine.EngineTemplateType;
import cn.smallbun.screw.core.exception.ProduceException;
import cn.smallbun.screw.core.metadata.model.DataModel;
import cn.smallbun.screw.core.util.Assert;
import cn.smallbun.screw.core.util.ExceptionUtils;
import cn.smallbun.screw.core.util.StringUtils;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityTemplateEngine
extends AbstractTemplateEngine {
    private static final String DATA = "_data";
    private static VelocityEngine velocityEngine;

    public VelocityTemplateEngine(EngineConfig templateConfig) {
        super(templateConfig);
        velocityEngine = new VelocityEngine();
        if (StringUtils.isNotBlank(this.getEngineConfig().getCustomTemplate())) {
            velocityEngine.setProperty("string.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.StringResourceLoader");
        } else {
            velocityEngine.setProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        }
        velocityEngine.setProperty("file.resource.loader.path", (Object)"");
        velocityEngine.setProperty("ISO-8859-1", (Object)"UTF-8");
        velocityEngine.setProperty("input.encoding", (Object)"UTF-8");
        velocityEngine.setProperty("file.resource.loader.unicode", (Object)"true");
    }

    @Override
    public void produce(DataModel info, String docName) throws ProduceException {
        Assert.notNull(info, "DataModel can not be empty!", new Object[0]);
        try {
            String path = this.getEngineConfig().getCustomTemplate();
            Template template = StringUtils.isNotBlank(path) ? velocityEngine.getTemplate(path, "UTF-8") : velocityEngine.getTemplate(EngineTemplateType.velocity.getTemplateDir() + this.getEngineConfig().getFileType().getTemplateNamePrefix() + EngineTemplateType.velocity.getSuffix(), "UTF-8");
            try (FileOutputStream outStream = new FileOutputStream(this.getFile(docName));
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outStream, "UTF-8");
                 BufferedWriter sw = new BufferedWriter(writer);){
                VelocityContext context = new VelocityContext();
                context.put(DATA, (Object)info);
                template.merge((Context)context, (Writer)sw);
                this.openOutputDir();
            }
        }
        catch (IOException e) {
            throw ExceptionUtils.mpe(e);
        }
    }
}

