/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.auth;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.LoginUserApi;
import cn.stylefeng.roses.kernel.auth.api.SessionManagerApi;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.context.LoginUserHolder;
import cn.stylefeng.roses.kernel.auth.api.exception.AuthException;
import cn.stylefeng.roses.kernel.auth.api.exception.enums.AuthExceptionEnum;
import cn.stylefeng.roses.kernel.auth.api.loginuser.CommonLoginUserUtil;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.sys.api.OrganizationServiceApi;
import cn.stylefeng.roses.kernel.sys.api.SysUserServiceApi;
import cn.stylefeng.roses.kernel.sys.api.pojo.org.CompanyDeptDTO;
import cn.stylefeng.roses.kernel.sys.api.pojo.user.TempLoginUserInfo;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class LoginUserImpl
implements LoginUserApi {
    @Resource
    private SessionManagerApi sessionManagerApi;
    @Resource
    private SysUserServiceApi sysUserServiceApi;
    @Resource
    private OrganizationServiceApi organizationServiceApi;

    public String getToken() {
        return CommonLoginUserUtil.getToken();
    }

    public LoginUser getLoginUser() throws AuthException {
        LoginUser currentUser = LoginUserHolder.get();
        if (currentUser != null) {
            return currentUser;
        }
        String token = this.getToken();
        LoginUser session = this.sessionManagerApi.getSession(token);
        if (session == null) {
            throw new AuthException((AbstractExceptionEnum)AuthExceptionEnum.AUTH_EXPIRED_ERROR);
        }
        return session;
    }

    public LoginUser getLoginUserNullable() {
        LoginUser currentUser = LoginUserHolder.get();
        if (currentUser != null) {
            return currentUser;
        }
        String token = null;
        try {
            token = this.getToken();
        }
        catch (Exception e) {
            return null;
        }
        return this.sessionManagerApi.getSession(token);
    }

    public boolean hasLogin() {
        String token = null;
        try {
            token = this.getToken();
        }
        catch (Exception e) {
            return false;
        }
        return this.sessionManagerApi.haveSession(token);
    }

    public boolean getSuperAdminFlag() {
        LoginUser loginUser = this.getLoginUser();
        return this.sysUserServiceApi.getUserSuperAdminFlag(loginUser.getUserId());
    }

    public Long getCurrentUserCompanyId() {
        Long currentOrgId = LoginContext.me().getLoginUser().getCurrentOrgId();
        if (currentOrgId == null) {
            return null;
        }
        CompanyDeptDTO orgCompanyInfo = this.organizationServiceApi.getOrgCompanyInfo(currentOrgId);
        if (orgCompanyInfo == null) {
            return null;
        }
        return orgCompanyInfo.getCompanyId();
    }

    public LoginUser switchTo(Long userId) {
        if (ObjectUtil.isEmpty((Object)userId)) {
            return null;
        }
        TempLoginUserInfo tempLoginUserInfo = this.sysUserServiceApi.createTempUserInfo(userId);
        if (tempLoginUserInfo == null) {
            return null;
        }
        LoginUser loginUser = new LoginUser();
        BeanUtil.copyProperties((Object)tempLoginUserInfo, (Object)loginUser, (CopyOptions)CopyOptions.create().ignoreError());
        loginUser.setToken("tempToken");
        LoginUserHolder.set((LoginUser)loginUser);
        return loginUser;
    }

    public void endSwitch() {
        LoginUserHolder.remove();
    }

    public void switchTo(Long userId, Consumer<Long> consumer) {
        this.switchTo(userId);
        consumer.accept(userId);
        this.endSwitch();
    }
}

