/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.jwt;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.stylefeng.roses.kernel.auth.api.AuthJwtTokenApi;
import cn.stylefeng.roses.kernel.auth.api.expander.AuthConfigExpander;
import cn.stylefeng.roses.kernel.auth.api.pojo.payload.DefaultJwtPayload;
import cn.stylefeng.roses.kernel.config.api.ConfigInitCallbackApi;
import cn.stylefeng.roses.kernel.jwt.api.JwtApi;
import cn.stylefeng.roses.kernel.jwt.api.pojo.config.JwtConfig;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AuthJwtTokenService
implements AuthJwtTokenApi,
ConfigInitCallbackApi {
    @Resource
    private JwtApi jwtApi;

    public String generateTokenDefaultPayload(DefaultJwtPayload defaultJwtPayload) {
        DateTime expirationDate = DateUtil.offsetSecond((Date)new Date(), (int)Convert.toInt((Object)AuthConfigExpander.getAuthJwtTimeoutSeconds()));
        defaultJwtPayload.setExpirationDate(Long.valueOf(expirationDate.getTime()));
        return Jwts.builder().setClaims(BeanUtil.beanToMap((Object)defaultJwtPayload, (String[])new String[0])).setSubject(defaultJwtPayload.getUserId().toString()).setIssuedAt(new Date()).setExpiration((Date)expirationDate).signWith(SignatureAlgorithm.HS512, AuthConfigExpander.getAuthJwtSecret()).compact();
    }

    public DefaultJwtPayload getDefaultPayload(String token) {
        Map jwtPayload = this.jwtApi.getJwtPayloadClaims(token);
        return (DefaultJwtPayload)BeanUtil.toBeanIgnoreError((Object)jwtPayload, DefaultJwtPayload.class);
    }

    public void initBefore() {
    }

    public void initAfter() {
        JwtConfig jwtConfig = new JwtConfig();
        jwtConfig.setJwtSecret(AuthConfigExpander.getAuthJwtSecret());
        jwtConfig.setExpiredSeconds(AuthConfigExpander.getAuthJwtTimeoutSeconds());
        this.jwtApi.updateJwtConfig(jwtConfig);
    }
}

