/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.auth.password;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.stylefeng.roses.kernel.auth.api.password.PasswordTransferEncryptApi;

public class RsaPasswordTransferEncrypt
implements PasswordTransferEncryptApi {
    private final String publicKey;
    private final String privateKey;

    public RsaPasswordTransferEncrypt(String publicKey, String privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public String encrypt(String originPassword) {
        if (StrUtil.isBlank((CharSequence)originPassword)) {
            return null;
        }
        RSA rsa = new RSA(this.privateKey, this.publicKey);
        return rsa.encryptBase64(originPassword, KeyType.PublicKey);
    }

    public String decrypt(String encryptedPassword) {
        RSA rsa = new RSA(this.privateKey, this.publicKey);
        return rsa.decryptStr(encryptedPassword, KeyType.PrivateKey);
    }
}

