/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.config.modular.listener;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.db.DbUtil;
import cn.stylefeng.roses.kernel.config.ConfigContainer;
import cn.stylefeng.roses.kernel.config.api.ConfigApi;
import cn.stylefeng.roses.kernel.config.api.context.ConfigContext;
import cn.stylefeng.roses.kernel.config.api.exception.ConfigException;
import cn.stylefeng.roses.kernel.config.api.exception.enums.ConfigExceptionEnum;
import cn.stylefeng.roses.kernel.config.modular.factory.SysConfigDataFactory;
import cn.stylefeng.roses.kernel.config.redis.RedisConfigContainer;
import cn.stylefeng.roses.kernel.rule.context.ApplicationPropertiesContext;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.listener.ContextInitializedListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class ConfigInitListener
extends ContextInitializedListener
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(ConfigInitListener.class);

    public int getOrder() {
        return -2147483548;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void eventCallback(ApplicationContextInitializedEvent event) {
        ConfigurableEnvironment environment = event.getApplicationContext().getEnvironment();
        boolean redisConfigCacheEnableFlag = this.getRedisOpenFlag();
        if (redisConfigCacheEnableFlag) {
            String redisHost = environment.getProperty("spring.redis.host");
            String redisPort = environment.getProperty("spring.redis.port");
            String redisPassword = environment.getProperty("spring.redis.password");
            String dbNumber = environment.getProperty("spring.redis.database");
            ConfigContext.setConfigApi((ConfigApi)new RedisConfigContainer(redisHost, Convert.toInt((Object)redisPort, (Integer)6379), redisPassword, Convert.toInt((Object)dbNumber, (Integer)0)));
        } else {
            ConfigContext.setConfigApi((ConfigApi)new ConfigContainer());
        }
        ApplicationPropertiesContext.getInstance().initConfigs(environment);
        String dataSourceUrl = environment.getProperty("spring.datasource.url");
        String dataSourceUsername = environment.getProperty("spring.datasource.username");
        String dataSourcePassword = environment.getProperty("spring.datasource.password");
        String driverClassName = environment.getProperty("spring.datasource.driver-class-name");
        if (ObjectUtil.hasEmpty((Object[])new Object[]{dataSourceUrl, dataSourceUsername, dataSourcePassword})) {
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.APP_DB_CONFIG_ERROR);
        }
        Connection conn = null;
        try {
            Class.forName(driverClassName);
            assert (dataSourceUrl != null);
            conn = DriverManager.getConnection(dataSourceUrl, dataSourceUsername, dataSourcePassword);
            List entityList = SysConfigDataFactory.getSysConfigDataApi(dataSourceUrl).getConfigs(conn);
            if (ObjectUtil.isNotEmpty((Object)entityList)) {
                entityList.forEach(sysConfig -> ConfigContext.me().putConfig(sysConfig.getStr("config_code"), (Object)sysConfig.getStr("config_value")));
            }
        }
        catch (ClassNotFoundException e) {
            try {
                log.error("\u521d\u59cb\u5316\u7cfb\u7edf\u914d\u7f6e\u8868\u5931\u8d25\uff0c\u627e\u4e0d\u5230{}\u7c7b : {}", (Object)driverClassName, (Object)driverClassName);
                throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CLASS_NOT_FOUND_ERROR);
                catch (SQLException sqlException) {
                    log.error("\u521d\u59cb\u5316\u7cfb\u7edf\u914d\u7f6e\u8868\u5931\u8d25\uff0c\u6267\u884c\u67e5\u8be2\u8bed\u53e5\u5931\u8d25", (Throwable)sqlException);
                    throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_SQL_EXE_ERROR);
                }
            }
            catch (Throwable throwable) {
                DbUtil.close((Object[])new Object[]{conn});
                throw throwable;
            }
        }
        DbUtil.close((Object[])new Object[]{conn});
    }

    private boolean getRedisOpenFlag() {
        try {
            Class.forName("org.springframework.data.redis.connection.RedisConnectionFactory");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

