/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.message.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.sys.api.MessageWebsocketApi;
import cn.stylefeng.roses.kernel.sys.api.enums.message.ReadFlagEnum;
import cn.stylefeng.roses.kernel.sys.api.pojo.message.MessageRetractDTO;
import cn.stylefeng.roses.kernel.sys.api.pojo.message.MessageSendDTO;
import cn.stylefeng.roses.kernel.sys.modular.message.entity.SysMessage;
import cn.stylefeng.roses.kernel.sys.modular.message.enums.SysMessageExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.message.factory.MessageFactory;
import cn.stylefeng.roses.kernel.sys.modular.message.mapper.SysMessageMapper;
import cn.stylefeng.roses.kernel.sys.modular.message.pojo.request.SysMessageRequest;
import cn.stylefeng.roses.kernel.sys.modular.message.service.SysMessageService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysMessageServiceImpl
extends ServiceImpl<SysMessageMapper, SysMessage>
implements SysMessageService {
    @Override
    public void del(SysMessageRequest sysMessageRequest) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(SysMessage::getReceiveUserId, (Object)LoginContext.me().getLoginUser().getUserId());
        wrapper.eq(SysMessage::getMessageId, (Object)sysMessageRequest.getMessageId());
        this.remove((Wrapper)wrapper);
    }

    @Override
    public SysMessage detail(SysMessageRequest sysMessageRequest) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysMessage::getReceiveUserId, (Object)LoginContext.me().getLoginUser().getUserId());
        wrapper.eq(SysMessage::getMessageId, (Object)sysMessageRequest.getMessageId());
        wrapper.select(new SFunction[]{SysMessage::getMessageId, SysMessage::getMessageTitle, SysMessage::getMessageContent, SysMessage::getPriorityLevel, SysMessage::getMessageSendTime, SysMessage::getMessageType, SysMessage::getMessageUrl, SysMessage::getBusinessType, SysMessage::getBusinessId});
        return this.querySysMessage(sysMessageRequest);
    }

    @Override
    public PageResult<SysMessage> findPage(SysMessageRequest sysMessageRequest) {
        LambdaQueryWrapper<SysMessage> wrapper = this.createWrapper(sysMessageRequest);
        wrapper.select(new SFunction[]{SysMessage::getMessageId, SysMessage::getMessageTitle, SysMessage::getPriorityLevel, SysMessage::getReadFlag, SysMessage::getMessageSendTime, SysMessage::getMessageType, SysMessage::getMessageUrl, SysMessage::getBusinessType, SysMessage::getBusinessId});
        Page pageList = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)pageList);
    }

    @Override
    public void deleteAllMyMessage() {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(SysMessage::getReceiveUserId, (Object)LoginContext.me().getLoginUser().getUserId());
        this.remove((Wrapper)wrapper);
    }

    @Override
    public void setReadFlag(SysMessageRequest sysMessageRequest) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(SysMessage::getReceiveUserId, (Object)LoginContext.me().getLoginUser().getUserId());
        wrapper.eq(SysMessage::getMessageId, (Object)sysMessageRequest.getMessageId());
        wrapper.set(SysMessage::getReadFlag, (Object)ReadFlagEnum.HAVE_READ.getCode());
        this.update((Wrapper)wrapper);
    }

    @Override
    public void setReadTotalReadFlag() {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(SysMessage::getReceiveUserId, (Object)LoginContext.me().getLoginUser().getUserId());
        wrapper.set(SysMessage::getReadFlag, (Object)ReadFlagEnum.HAVE_READ.getCode());
        this.update((Wrapper)wrapper);
    }

    public void batchSendMessage(MessageSendDTO messageSendDTO) {
        List<SysMessage> batchMessage = MessageFactory.createBatchMessage(messageSendDTO);
        if (ObjectUtil.isNotEmpty(batchMessage)) {
            ((SysMessageMapper)this.getBaseMapper()).insertBatchSomeColumn(batchMessage);
        }
        try {
            MessageWebsocketApi messageWebsocketApi = (MessageWebsocketApi)SpringUtil.getBean(MessageWebsocketApi.class);
            messageWebsocketApi.wsSendMessage(MessageFactory.createSocketMessage(batchMessage));
        }
        catch (Exception e) {
            this.log.error("\u3010websocket\u670d\u52a1\u3011\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public void batchRetractMessage(MessageRetractDTO messageRetractDTO) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(SysMessage::getBusinessType, (Object)messageRetractDTO.getBusinessType());
        wrapper.eq(SysMessage::getBusinessId, (Object)messageRetractDTO.getBusinessId());
        if (ObjectUtil.isNotEmpty((Object)messageRetractDTO.getUserIdList())) {
            wrapper.in(SysMessage::getReceiveUserId, (Collection)messageRetractDTO.getUserIdList());
        }
        this.remove((Wrapper)wrapper);
    }

    private SysMessage querySysMessage(SysMessageRequest sysMessageRequest) {
        SysMessage sysMessage = (SysMessage)((Object)this.getById(sysMessageRequest.getMessageId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysMessage))) {
            throw new ServiceException((AbstractExceptionEnum)SysMessageExceptionEnum.SYS_MESSAGE_NOT_EXISTED);
        }
        return sysMessage;
    }

    private LambdaQueryWrapper<SysMessage> createWrapper(SysMessageRequest sysMessageRequest) {
        Integer readFlag;
        String priorityLevel;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String searchText = sysMessageRequest.getSearchText();
        if (StrUtil.isNotBlank((CharSequence)searchText)) {
            queryWrapper.like(SysMessage::getMessageTitle, (Object)searchText);
        }
        if (ObjectUtil.isNotEmpty((Object)(priorityLevel = sysMessageRequest.getPriorityLevel()))) {
            queryWrapper.eq(SysMessage::getPriorityLevel, (Object)priorityLevel);
        }
        if (ObjectUtil.isNotEmpty((Object)(readFlag = sysMessageRequest.getReadFlag()))) {
            queryWrapper.eq(SysMessage::getReadFlag, (Object)readFlag);
        }
        queryWrapper.eq(SysMessage::getReceiveUserId, (Object)LoginContext.me().getLoginUser().getUserId());
        queryWrapper.orderByAsc(SysMessage::getReadFlag);
        queryWrapper.orderByDesc(SysMessage::getMessageSendTime);
        return queryWrapper;
    }
}

