/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.theme.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.sys.api.exception.SysException;
import cn.stylefeng.roses.kernel.sys.modular.theme.entity.SysTheme;
import cn.stylefeng.roses.kernel.sys.modular.theme.entity.SysThemeTemplate;
import cn.stylefeng.roses.kernel.sys.modular.theme.entity.SysThemeTemplateField;
import cn.stylefeng.roses.kernel.sys.modular.theme.entity.SysThemeTemplateRel;
import cn.stylefeng.roses.kernel.sys.modular.theme.exceptions.SysThemeExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.theme.exceptions.SysThemeTemplateExceptionEnum;
import cn.stylefeng.roses.kernel.sys.modular.theme.mapper.SysThemeTemplateMapper;
import cn.stylefeng.roses.kernel.sys.modular.theme.pojo.SysThemeTemplateDataDTO;
import cn.stylefeng.roses.kernel.sys.modular.theme.pojo.SysThemeTemplateRequest;
import cn.stylefeng.roses.kernel.sys.modular.theme.service.SysThemeService;
import cn.stylefeng.roses.kernel.sys.modular.theme.service.SysThemeTemplateFieldService;
import cn.stylefeng.roses.kernel.sys.modular.theme.service.SysThemeTemplateRelService;
import cn.stylefeng.roses.kernel.sys.modular.theme.service.SysThemeTemplateService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysThemeTemplateServiceImpl
extends ServiceImpl<SysThemeTemplateMapper, SysThemeTemplate>
implements SysThemeTemplateService {
    @Resource
    private SysThemeTemplateMapper sysThemeTemplateMapper;
    @Resource
    private SysThemeService sysThemeService;
    @Resource
    private SysThemeTemplateRelService sysThemeTemplateRelService;
    @Resource
    private SysThemeTemplateFieldService sysThemeTemplateFieldService;

    @Override
    public void add(SysThemeTemplateRequest sysThemeTemplateRequest) {
        SysThemeTemplate sysThemeTemplate = new SysThemeTemplate();
        BeanUtil.copyProperties((Object)((Object)sysThemeTemplateRequest), (Object)((Object)sysThemeTemplate), (String[])new String[0]);
        sysThemeTemplate.setStatusFlag(Character.valueOf(YesOrNotEnum.N.getCode().charAt(0)));
        this.save((Object)sysThemeTemplate);
    }

    @Override
    public void edit(SysThemeTemplateRequest sysThemeTemplateRequest) {
        SysThemeTemplate sysThemeTemplate = this.querySysThemeTemplateById(sysThemeTemplateRequest);
        if (YesOrNotEnum.Y.getCode().equals(sysThemeTemplate.getStatusFlag().toString())) {
            throw new SysException((AbstractExceptionEnum)SysThemeTemplateExceptionEnum.TEMPLATE_IS_USED);
        }
        BeanUtil.copyProperties((Object)((Object)sysThemeTemplateRequest), (Object)((Object)sysThemeTemplate), (String[])new String[0]);
        this.updateById((Object)sysThemeTemplate);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SysThemeTemplateRequest sysThemeTemplateRequest) {
        SysThemeTemplate sysThemeTemplate = this.querySysThemeTemplateById(sysThemeTemplateRequest);
        if (sysThemeTemplate.getTemplateCode().toUpperCase(Locale.ROOT).startsWith("GUNS")) {
            throw new SysException((AbstractExceptionEnum)SysThemeExceptionEnum.THEME_IS_SYSTEM);
        }
        if (YesOrNotEnum.Y.getCode().equals(sysThemeTemplate.getStatusFlag().toString())) {
            throw new SysException((AbstractExceptionEnum)SysThemeTemplateExceptionEnum.TEMPLATE_IS_ENABLE);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysThemeTemplateRel::getTemplateId, (Object)sysThemeTemplate.getTemplateId());
        this.sysThemeTemplateRelService.remove((Wrapper)queryWrapper);
        this.removeById((Object)sysThemeTemplate);
    }

    @Override
    public PageResult<SysThemeTemplate> findPage(SysThemeTemplateRequest sysThemeTemplateRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(StrUtil.isNotBlank((CharSequence)sysThemeTemplateRequest.getTemplateName()), SysThemeTemplate::getTemplateName, (Object)sysThemeTemplateRequest.getTemplateName());
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)queryWrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public List<SysThemeTemplate> findList(SysThemeTemplateRequest sysThemeTemplateRequest) {
        return this.list();
    }

    @Override
    public void updateTemplateStatus(SysThemeTemplateRequest sysThemeTemplateRequest) {
        SysThemeTemplate sysThemeTemplate = this.querySysThemeTemplateById(sysThemeTemplateRequest);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysTheme::getTemplateId, (Object)sysThemeTemplate.getTemplateId());
        long sysThemeNum = this.sysThemeService.count((Wrapper)queryWrapper);
        if (sysThemeNum > 0L) {
            throw new SysException((AbstractExceptionEnum)SysThemeTemplateExceptionEnum.TEMPLATE_IS_USED);
        }
        if (YesOrNotEnum.Y.getCode().equals(sysThemeTemplate.getStatusFlag().toString())) {
            sysThemeTemplate.setStatusFlag(Character.valueOf(YesOrNotEnum.N.getCode().charAt(0)));
        } else {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysThemeTemplateRel::getTemplateId, (Object)sysThemeTemplate.getTemplateId());
            List sysThemeTemplateRels = this.sysThemeTemplateRelService.list((Wrapper)wrapper);
            if (sysThemeTemplateRels.size() <= 0) {
                throw new SysException((AbstractExceptionEnum)SysThemeTemplateExceptionEnum.TEMPLATE_NOT_ATTRIBUTE);
            }
            sysThemeTemplate.setStatusFlag(Character.valueOf(YesOrNotEnum.Y.getCode().charAt(0)));
        }
        this.updateById((Object)sysThemeTemplate);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<SysThemeTemplateDataDTO> detail(SysThemeTemplateRequest sysThemeTemplateRequest) {
        Long templateId = sysThemeTemplateRequest.getTemplateId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysThemeTemplate::getTemplateId, (Object)templateId);
        wrapper.select(new SFunction[]{SysThemeTemplate::getTemplateId, SysThemeTemplate::getTemplateCode, SysThemeTemplate::getTemplateName});
        SysThemeTemplate sysThemeTemplate = (SysThemeTemplate)((Object)this.getOne((Wrapper)wrapper, false));
        if (sysThemeTemplate == null) {
            throw new ServiceException((AbstractExceptionEnum)SysThemeTemplateExceptionEnum.TEMPLATE_NOT_EXIT);
        }
        List<String> templateFieldCodeList = this.sysThemeTemplateRelService.getThemeTemplateFieldCodeList(templateId);
        List<SysThemeTemplateField> fieldListByFieldCode = this.sysThemeTemplateFieldService.getFieldListByFieldCode(templateFieldCodeList);
        List resultList = BeanUtil.copyToList(fieldListByFieldCode, SysThemeTemplateDataDTO.class);
        for (SysThemeTemplateDataDTO sysThemeTemplateDataDTO : resultList) {
            sysThemeTemplateDataDTO.setTemplateId(sysThemeTemplate.getTemplateId());
            sysThemeTemplateDataDTO.setTemplateName(sysThemeTemplate.getTemplateName());
            sysThemeTemplateDataDTO.setTemplateCode(sysThemeTemplate.getTemplateCode());
        }
        return resultList;
    }

    private SysThemeTemplate querySysThemeTemplateById(SysThemeTemplateRequest sysThemeTemplateRequest) {
        SysThemeTemplate sysThemeTemplate = (SysThemeTemplate)((Object)this.getById(sysThemeTemplateRequest.getTemplateId()));
        if (ObjectUtil.isNull((Object)((Object)sysThemeTemplate))) {
            throw new SysException((AbstractExceptionEnum)SysThemeTemplateExceptionEnum.TEMPLATE_NOT_EXIT);
        }
        return sysThemeTemplate;
    }
}

