/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.modular.userapp.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.dsctn.api.context.DataSourceContext;
import cn.stylefeng.roses.kernel.rule.enums.DbTypeEnum;
import cn.stylefeng.roses.kernel.sys.api.SysMenuServiceApi;
import cn.stylefeng.roses.kernel.sys.api.pojo.menu.UserAppMenuInfo;
import cn.stylefeng.roses.kernel.sys.modular.userapp.entity.PortalUserApp;
import cn.stylefeng.roses.kernel.sys.modular.userapp.mapper.PortalUserAppMapper;
import cn.stylefeng.roses.kernel.sys.modular.userapp.pojo.request.PortalUserAppRequest;
import cn.stylefeng.roses.kernel.sys.modular.userapp.service.PortalUserAppService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalUserAppServiceImpl
extends ServiceImpl<PortalUserAppMapper, PortalUserApp>
implements PortalUserAppService {
    @Resource
    private SysMenuServiceApi sysMenuServiceApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUserAppList(PortalUserAppRequest portalUserAppRequest) {
        Long userId = LoginContext.me().getLoginUser().getUserId();
        LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
        removeWrapper.eq(PortalUserApp::getUserId, (Object)userId);
        this.remove((Wrapper)removeWrapper);
        Map menuIdAppIdMap = this.sysMenuServiceApi.getMenuAppId(portalUserAppRequest.getMenuIdList());
        ArrayList<PortalUserApp> portalUserApps = new ArrayList<PortalUserApp>();
        for (Long menuId : portalUserAppRequest.getMenuIdList()) {
            PortalUserApp portalUserApp = new PortalUserApp();
            portalUserApp.setUserId(userId);
            portalUserApp.setAppId((Long)menuIdAppIdMap.get(menuId));
            portalUserApp.setMenuId(menuId);
            portalUserApps.add(portalUserApp);
        }
        if (DbTypeEnum.MYSQL.equals((Object)DataSourceContext.me().getCurrentDbType())) {
            ((PortalUserAppMapper)this.getBaseMapper()).insertBatchSomeColumn(portalUserApps);
        } else {
            this.saveBatch(portalUserApps);
        }
    }

    @Override
    public List<UserAppMenuInfo> getUserAppList() {
        Long userId = LoginContext.me().getLoginUser().getUserId();
        LambdaQueryWrapper portalUserAppLambdaQueryWrapper = new LambdaQueryWrapper();
        portalUserAppLambdaQueryWrapper.eq(PortalUserApp::getUserId, (Object)userId);
        portalUserAppLambdaQueryWrapper.select(new SFunction[]{PortalUserApp::getMenuId});
        List userAppList = this.list((Wrapper)portalUserAppLambdaQueryWrapper);
        if (ObjectUtil.isEmpty((Object)userAppList)) {
            return new ArrayList<UserAppMenuInfo>();
        }
        Set totalMenuIdList = userAppList.stream().map(PortalUserApp::getMenuId).collect(Collectors.toSet());
        return this.sysMenuServiceApi.getUserAppMenuDetailList(totalMenuIdList);
    }
}

