/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.sys.starter.cache.role;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.sys.api.constants.SysConstants;
import cn.stylefeng.roses.kernel.sys.modular.role.cache.rolemenu.RoleMenuMemoryCache;
import cn.stylefeng.roses.kernel.sys.modular.role.cache.roleoptions.RoleMenuOptionsMemoryCache;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnMissingClass(value={"org.springframework.data.redis.connection.RedisConnectionFactory"})
public class RoleMemoryCacheAutoConfiguration {
    @Bean
    public CacheOperatorApi<List<Long>> roleMenuCache() {
        TimedCache cache = CacheUtil.newTimedCache((long)(1000L * SysConstants.DEFAULT_SYS_CACHE_TIMEOUT_SECONDS));
        return new RoleMenuMemoryCache(cache);
    }

    @Bean
    public CacheOperatorApi<List<Long>> roleMenuOptionsCache() {
        TimedCache cache = CacheUtil.newTimedCache((long)(1000L * SysConstants.DEFAULT_SYS_CACHE_TIMEOUT_SECONDS));
        return new RoleMenuOptionsMemoryCache(cache);
    }
}

